/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.elasticsearch;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.elasticsearch.ElasticSearchConnectable;
import com.datatorrent.lib.db.AbstractStoreInputOperator;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.search.SearchHit;

public abstract class AbstractElasticSearchInputOperator<T, S extends ElasticSearchConnectable>
extends AbstractStoreInputOperator<T, S> {
    protected transient SearchRequestBuilder searchRequestBuilder;

    public void setup(Context.OperatorContext t1) {
        super.setup(t1);
        this.searchRequestBuilder = new SearchRequestBuilder((Client)((ElasticSearchConnectable)this.store).client);
    }

    public void emitTuples() {
        SearchResponse response = (SearchResponse)this.getSearchRequestBuilder().execute().actionGet();
        for (SearchHit hit : response.getHits().hits()) {
            T tuple = this.convertToTuple(hit);
            if (tuple == null) continue;
            this.outputPort.emit(tuple);
        }
    }

    protected abstract T convertToTuple(SearchHit var1);

    protected abstract SearchRequestBuilder getSearchRequestBuilder();
}

