/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.enrich;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.contrib.enrich.BackendLoader;
import com.datatorrent.contrib.enrich.NullValuesCacheManager;
import com.datatorrent.lib.db.cache.CacheManager;
import com.datatorrent.lib.db.cache.CacheStore;
import com.datatorrent.lib.util.FieldInfo;
import com.esotericsoftware.kryo.NotNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public abstract class AbstractEnricher<INPUT, OUTPUT>
extends BaseOperator
implements Operator.ActivationListener {
    @NotNull
    protected List<String> lookupFields;
    @NotNull
    protected List<String> includeFields;
    @NotNull
    private BackendLoader store;
    private int cacheExpirationInterval = 3600000;
    private int cacheCleanupInterval = 3600000;
    private int cacheSize = 1024;
    private transient CacheManager cacheManager;
    protected transient List<FieldInfo> lookupFieldInfo = new ArrayList<FieldInfo>();
    protected transient List<FieldInfo> includeFieldInfo = new ArrayList<FieldInfo>();

    protected void enrichTuple(INPUT tuple) {
        Object result;
        OUTPUT out;
        Object key = this.getKey(tuple);
        if (key != null && (out = this.convert(tuple, result = this.cacheManager.get(key))) != null) {
            this.emitEnrichedTuple(out);
        }
    }

    protected abstract Object getKey(INPUT var1);

    protected abstract OUTPUT convert(INPUT var1, Object var2);

    protected abstract void emitEnrichedTuple(OUTPUT var1);

    protected abstract Class<?> getIncludeFieldType(String var1);

    protected abstract Class<?> getLookupFieldType(String var1);

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.cacheManager = new NullValuesCacheManager();
        CacheStore primaryCache = new CacheStore();
        primaryCache.setEntryExpiryDurationInMillis(this.cacheExpirationInterval);
        primaryCache.setCacheCleanupInMillis(this.cacheCleanupInterval);
        primaryCache.setEntryExpiryStrategy(CacheStore.ExpiryType.EXPIRE_AFTER_WRITE);
        primaryCache.setMaxCacheSize((long)this.cacheSize);
        this.cacheManager.setPrimary((CacheManager.Primary)primaryCache);
        this.cacheManager.setBackup((CacheManager.Backup)this.store);
    }

    public void activate(Context context) {
        for (String s : this.lookupFields) {
            this.lookupFieldInfo.add(new FieldInfo(s, s, FieldInfo.SupportType.getFromJavaType(this.getLookupFieldType(s))));
        }
        if (this.includeFields != null) {
            for (String s : this.includeFields) {
                this.includeFieldInfo.add(new FieldInfo(s, s, FieldInfo.SupportType.getFromJavaType(this.getIncludeFieldType(s))));
            }
        }
        this.store.setFieldInfo(this.lookupFieldInfo, this.includeFieldInfo);
        try {
            this.cacheManager.initialize();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize primary cache", e);
        }
    }

    public void deactivate() {
    }

    public List<String> getLookupFields() {
        return this.lookupFields;
    }

    public void setLookupFields(List<String> lookupFields) {
        this.lookupFields = lookupFields;
    }

    public List<String> getIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(List<String> includeFields) {
        this.includeFields = includeFields;
    }

    public BackendLoader getStore() {
        return this.store;
    }

    public void setStore(BackendLoader store) {
        this.store = store;
    }

    public int getCacheExpirationInterval() {
        return this.cacheExpirationInterval;
    }

    public void setCacheExpirationInterval(int cacheExpirationInterval) {
        this.cacheExpirationInterval = cacheExpirationInterval;
    }

    public int getCacheCleanupInterval() {
        return this.cacheCleanupInterval;
    }

    public void setCacheCleanupInterval(int cacheCleanupInterval) {
        this.cacheCleanupInterval = cacheCleanupInterval;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
}

