/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.enrich;

import com.datatorrent.contrib.enrich.ReadOnlyBackup;
import com.datatorrent.lib.util.FieldInfo;
import com.esotericsoftware.kryo.NotNull;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class FSLoader
extends ReadOnlyBackup {
    @NotNull
    private String fileName;
    private transient Path filePath;
    private transient FileSystem fs;
    private transient boolean connected;
    private static final Logger logger = LoggerFactory.getLogger(FSLoader.class);

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Object, Object> loadInitialData() {
        FSDataInputStream in;
        HashMap result;
        block14: {
            result = null;
            in = null;
            BufferedReader bin = null;
            try {
                String line;
                result = Maps.newHashMap();
                in = this.fs.open(this.filePath);
                bin = new BufferedReader(new InputStreamReader((InputStream)in));
                while ((line = bin.readLine()) != null) {
                    try {
                        Map<String, Object> tuple = this.extractFields(line);
                        if (tuple == null || tuple.isEmpty()) continue;
                        result.put(this.getKey(tuple), this.getValue(tuple));
                    }
                    catch (Exception parseExp) {
                        logger.info("Unable to parse line {}", (Object)line);
                    }
                }
                if (bin == null) break block14;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (bin != null) {
                        IOUtils.closeQuietly(bin);
                    }
                    if (in != null) {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    try {
                        this.fs.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            IOUtils.closeQuietly((Reader)bin);
        }
        if (in != null) {
            IOUtils.closeQuietly((InputStream)in);
        }
        try {
            this.fs.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.debug("loading initial data {}", (Object)result.size());
        return result;
    }

    abstract Map<String, Object> extractFields(String var1);

    private Object getValue(Map<String, Object> tuple) {
        ArrayList<Object> includeTuple = new ArrayList<Object>();
        for (FieldInfo s : this.includeFieldInfo) {
            includeTuple.add(tuple.get(s.getColumnName()));
        }
        return includeTuple;
    }

    private Object getKey(Map<String, Object> tuple) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (FieldInfo key : this.lookupFieldInfo) {
            list.add(tuple.get(key.getColumnName()));
        }
        return list;
    }

    public Object get(Object key) {
        return null;
    }

    public List<Object> getAll(List<Object> keys) {
        return null;
    }

    public void connect() throws IOException {
        Configuration conf = new Configuration();
        this.filePath = new Path(this.fileName);
        this.fs = FileSystem.newInstance((URI)this.filePath.toUri(), (Configuration)conf);
        if (!this.fs.isFile(this.filePath)) {
            throw new IOException("Provided path " + this.fileName + " is not a file");
        }
        this.connected = true;
    }

    public void disconnect() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }
}

