/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.formatter;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.contrib.parser.DelimitedSchema;
import com.datatorrent.lib.formatter.Formatter;
import com.datatorrent.netlet.util.DTThrowable;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.FmtDate;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

@InterfaceStability.Evolving
public class CsvFormatter
extends Formatter<String> {
    private transient String[] nameMapping;
    private transient CellProcessor[] processors;
    private transient CsvPreference preference;
    @NotNull
    private String schema;
    private transient DelimitedSchema delimitedParserSchema;
    @AutoMetric
    private long errorTupleCount;
    @AutoMetric
    private long emittedObjectCount;
    @AutoMetric
    private long incomingTuplesCount;
    private static final Logger logger = LoggerFactory.getLogger(CsvFormatter.class);

    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.errorTupleCount = 0L;
        this.emittedObjectCount = 0L;
        this.incomingTuplesCount = 0L;
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.delimitedParserSchema = new DelimitedSchema(this.schema);
        this.preference = new CsvPreference.Builder(this.delimitedParserSchema.getQuoteChar(), this.delimitedParserSchema.getDelimiterChar(), this.delimitedParserSchema.getLineDelimiter()).build();
        this.nameMapping = this.delimitedParserSchema.getFieldNames().toArray(new String[this.delimitedParserSchema.getFieldNames().size()]);
        this.processors = this.getProcessor(this.delimitedParserSchema.getFields());
    }

    private CellProcessor[] getProcessor(List<DelimitedSchema.Field> fields) {
        CellProcessor[] processor = new CellProcessor[fields.size()];
        int fieldCount = 0;
        for (DelimitedSchema.Field field : fields) {
            if (field.getType() == DelimitedSchema.FieldType.DATE) {
                String format = field.getConstraints().get("format") == null ? null : (String)field.getConstraints().get("format");
                processor[fieldCount++] = new Optional((CellProcessor)new FmtDate(format == null ? "dd/MM/yyyy" : format));
                continue;
            }
            processor[fieldCount++] = new Optional();
        }
        return processor;
    }

    public String convert(Object tuple) {
        ++this.incomingTuplesCount;
        if (tuple == null) {
            ++this.errorTupleCount;
            logger.error(" Null tuple", tuple);
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            CsvBeanWriter beanWriter = new CsvBeanWriter((Writer)stringWriter, this.preference);
            beanWriter.write(tuple, this.nameMapping, this.processors);
            beanWriter.flush();
            beanWriter.close();
            ++this.emittedObjectCount;
            return stringWriter.toString();
        }
        catch (SuperCsvException e) {
            logger.error("Error while converting tuple {} {}", tuple, (Object)e.getMessage());
            ++this.errorTupleCount;
        }
        catch (IOException e) {
            DTThrowable.rethrow((Exception)e);
        }
        return null;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @VisibleForTesting
    protected long getErrorTupleCount() {
        return this.errorTupleCount;
    }

    @VisibleForTesting
    protected long getEmittedObjectCount() {
        return this.emittedObjectCount;
    }

    @VisibleForTesting
    protected long getIncomingTuplesCount() {
        return this.incomingTuplesCount;
    }
}

