/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.geode;

import com.datatorrent.lib.db.KeyValueStore;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeStore
implements KeyValueStore,
Serializable {
    private static final long serialVersionUID = -5076452548893319967L;
    private static final Logger logger = LoggerFactory.getLogger(GeodeStore.class);
    private transient ClientCache clientCache = null;
    private transient Region<Object, Object> region = null;
    private String locatorHost;
    private int locatorPort;
    private String regionName;

    private ClientCache initClient() {
        try {
            this.clientCache = new ClientCacheFactory().addPoolLocator(this.getLocatorHost(), this.getLocatorPort()).create();
        }
        catch (CacheClosedException ex) {
            throw new RuntimeException("Exception while creating cache", ex);
        }
        return this.clientCache;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public ClientCache getClientCache() {
        return this.clientCache;
    }

    public int getLocatorPort() {
        return this.locatorPort;
    }

    public void setLocatorPort(int locatorPort) {
        this.locatorPort = locatorPort;
    }

    public String getLocatorHost() {
        return this.locatorHost;
    }

    public void setLocatorHost(String locatorHost) {
        this.locatorHost = locatorHost;
    }

    public Region<Object, Object> getRegion() throws IOException {
        if (this.clientCache == null || this.clientCache.isClosed()) {
            this.initClient();
        }
        if (this.region == null) {
            this.region = this.clientCache.getRegion(this.regionName);
            if (this.region == null) {
                this.region = this.clientCache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(this.regionName);
            }
        }
        return this.region;
    }

    public void connect() throws IOException {
        try {
            this.clientCache = new ClientCacheFactory().addPoolLocator(this.getLocatorHost(), this.getLocatorPort()).create();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.region = this.clientCache.getRegion(this.getRegionName());
        if (this.region == null) {
            this.region = this.clientCache.createClientRegionFactory(ClientRegionShortcut.PROXY).create(this.getRegionName());
        }
    }

    public void disconnect() throws IOException {
        this.clientCache.close();
    }

    public boolean isConnected() {
        return this.clientCache.isClosed();
    }

    public Object get(Object key) {
        try {
            return this.getRegion().get(key);
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception while getting the object", ex);
        }
    }

    public List<Object> getAll(List<Object> keys) {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            Map entries = this.getRegion().getAll(keys);
            for (int i = 0; i < keys.size(); ++i) {
                values.add(entries.get(keys.get(i)));
            }
        }
        catch (IOException ex) {
            logger.info("error getting region ", (Throwable)ex);
        }
        return values;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Map<Object, Object> getAllMap(List<Object> keys) {
        try {
            Map entries = this.getRegion().getAll(keys);
            return entries;
        }
        catch (IOException ex) {
            logger.info("error getting object ", (Throwable)ex);
            return null;
        }
    }

    public SelectResults query(String predicate) {
        try {
            return this.getRegion().query(predicate);
        }
        catch (FunctionDomainException | NameResolutionException | QueryInvocationTargetException | TypeMismatchException | IOException e) {
            logger.info("error in querying object ", e);
            return null;
        }
    }

    public void put(Object key, Object value) {
        try {
            this.getRegion().put(key, value);
        }
        catch (IOException e) {
            logger.info("while putting in region", (Throwable)e);
        }
    }

    public void putAll(Map<Object, Object> map) {
        try {
            this.getRegion().putAll(map);
        }
        catch (IOException e) {
            logger.info("while putting all in region", (Throwable)e);
        }
    }

    public void remove(Object key) {
        try {
            this.getRegion().destroy(key);
        }
        catch (CacheWriterException | EntryNotFoundException | TimeoutException | IOException e) {
            logger.info("while deleting", e);
        }
    }
}

