/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.contrib.hbase.HBaseStore;
import com.datatorrent.lib.db.AbstractStoreOutputOperator;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.InterruptedIOException;
import javax.validation.constraints.Min;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBasePutOutputOperator<T>
extends AbstractStoreOutputOperator<T, HBaseStore> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractHBasePutOutputOperator.class);
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private int batchSize = 1000;
    protected int unCommittedSize = 0;

    public AbstractHBasePutOutputOperator() {
        this.store = new HBaseStore();
    }

    public void processTuple(T tuple) {
        HTable table = ((HBaseStore)this.store).getTable();
        Put put = this.operationPut(tuple);
        try {
            table.put(put);
            if (++this.unCommittedSize >= this.batchSize) {
                table.flushCommits();
                this.unCommittedSize = 0;
            }
        }
        catch (RetriesExhaustedWithDetailsException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        catch (InterruptedIOException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    public void endWindow() {
        try {
            if (this.unCommittedSize > 0) {
                ((HBaseStore)this.store).getTable().flushCommits();
                this.unCommittedSize = 0;
            }
        }
        catch (RetriesExhaustedWithDetailsException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        catch (InterruptedIOException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    public abstract Put operationPut(T var1);

    @Min(value=1L)
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

