/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.hbase.HBaseWindowStore;
import com.datatorrent.lib.db.AbstractAggregateTransactionableStoreOutputOperator;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBaseWindowAppendOutputOperator<T>
extends AbstractAggregateTransactionableStoreOutputOperator<T, HBaseWindowStore> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractHBaseWindowAppendOutputOperator.class);
    private List<T> tuples;
    private transient Operator.ProcessingMode mode;

    public Operator.ProcessingMode getMode() {
        return this.mode;
    }

    public void setMode(Operator.ProcessingMode mode) {
        this.mode = mode;
    }

    public AbstractHBaseWindowAppendOutputOperator() {
        this.store = new HBaseWindowStore();
        this.tuples = new ArrayList<T>();
    }

    public void storeAggregate() {
        HTable table = ((HBaseWindowStore)this.store).getTable();
        for (T t : this.tuples) {
            try {
                Append append = this.operationAppend(t);
                table.append(append);
            }
            catch (IOException e) {
                logger.error("Could not output tuple", (Throwable)e);
                DTThrowable.rethrow((Exception)e);
            }
        }
        try {
            table.flushCommits();
        }
        catch (RetriesExhaustedWithDetailsException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        catch (InterruptedIOException e) {
            logger.error("Could not output tuple", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
        this.tuples.clear();
    }

    public abstract Append operationAppend(T var1);

    public void processTuple(T tuple) {
        this.tuples.add(tuple);
    }

    public void setup(Context.OperatorContext context) {
        this.mode = (Operator.ProcessingMode)context.getValue(Context.OperatorContext.PROCESSING_MODE);
        if (this.mode == Operator.ProcessingMode.EXACTLY_ONCE) {
            throw new RuntimeException("This operator only supports atmost once and atleast once processing modes");
        }
        if (this.mode == Operator.ProcessingMode.AT_MOST_ONCE) {
            this.tuples.clear();
        }
        super.setup(context);
    }
}

