/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.hbase.AbstractHBaseWindowPutOutputOperator;
import com.datatorrent.lib.util.ReusableStringReader;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.prefs.CsvPreference;

public class HBaseCsvMappingPutOperator
extends AbstractHBaseWindowPutOutputOperator<String> {
    private static final transient Logger logger = LoggerFactory.getLogger(HBaseCsvMappingPutOperator.class);
    private transient Integer rowIndex;
    private transient Map<Integer, ColDef> colMap = new HashMap<Integer, ColDef>();
    private transient ICsvListReader lineListReader = null;
    private transient ReusableStringReader lineSr = new ReusableStringReader();
    private transient ArrayList<String> csvLineList = new ArrayList();
    private String mappingString;

    public void setMappingString(String mappingString) {
        this.mappingString = mappingString;
    }

    @Override
    public Put operationPut(String t) throws IOException {
        return this.parseLine(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseMapping() {
        CsvListReader listReader = null;
        StringReader sr = null;
        ArrayList csvList = new ArrayList();
        try {
            sr = new StringReader(this.mappingString);
            listReader = new CsvListReader((Reader)sr, CsvPreference.STANDARD_PREFERENCE);
            csvList = (ArrayList)listReader.read();
        }
        catch (IOException e) {
            logger.error("Cannot read the mapping string", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
        finally {
            try {
                sr.close();
                listReader.close();
            }
            catch (IOException e) {
                logger.error("Error closing Csv reader", (Throwable)e);
                DTThrowable.rethrow((Exception)e);
            }
        }
        for (int index = 0; index < csvList.size(); ++index) {
            String value = (String)csvList.get(index);
            if (value.equals("row")) {
                this.rowIndex = index;
                continue;
            }
            ColDef c = new ColDef();
            c.colFam = value.substring(0, value.indexOf(46));
            c.colName = value.substring(value.indexOf(46) + 1);
            this.colMap.put(index, c);
        }
    }

    public Put parseLine(String s) {
        Put put = null;
        try {
            this.lineSr.open(s);
            this.csvLineList = (ArrayList)this.lineListReader.read();
        }
        catch (IOException e) {
            logger.error("Cannot read the property string", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
        put = new Put(this.csvLineList.get(this.rowIndex).getBytes());
        for (Map.Entry<Integer, ColDef> e : this.colMap.entrySet()) {
            String colValue = this.csvLineList.get(e.getKey());
            put.add(e.getValue().colFam.getBytes(), e.getValue().colName.getBytes(), colValue.getBytes());
        }
        this.csvLineList.clear();
        return put;
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.parseMapping();
        this.lineListReader = new CsvListReader((Reader)this.lineSr, CsvPreference.STANDARD_PREFERENCE);
    }

    public void teardown() {
        super.teardown();
        try {
            this.lineSr.close();
            this.lineListReader.close();
        }
        catch (IOException e) {
            logger.error("Cannot close the readers", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    private class ColDef {
        String colFam;
        String colName;

        private ColDef() {
        }
    }
}

