/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.lib.util.FieldInfo;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseFieldInfo
extends FieldInfo {
    private String familyName;

    public HBaseFieldInfo() {
    }

    public HBaseFieldInfo(String columnName, String columnExpression, FieldInfo.SupportType type, String familyName) {
        super(columnName, columnExpression, type);
        this.setFamilyName(familyName);
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public byte[] toBytes(Object value) {
        FieldInfo.SupportType type = this.getType();
        switch (type) {
            case BOOLEAN: {
                return Bytes.toBytes((boolean)((Boolean)value));
            }
            case SHORT: {
                return Bytes.toBytes((short)((Short)value));
            }
            case INTEGER: {
                return Bytes.toBytes((int)((Integer)value));
            }
            case LONG: {
                return Bytes.toBytes((long)((Long)value));
            }
            case FLOAT: {
                return Bytes.toBytes((float)((Float)value).floatValue());
            }
            case DOUBLE: {
                return Bytes.toBytes((double)((Double)value));
            }
            case STRING: {
                return Bytes.toBytes((String)((String)value));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public Object toValue(byte[] bytes) {
        FieldInfo.SupportType type = this.getType();
        switch (type) {
            case BOOLEAN: {
                return Bytes.toBoolean((byte[])bytes);
            }
            case SHORT: {
                return Bytes.toShort((byte[])bytes);
            }
            case INTEGER: {
                return Bytes.toInt((byte[])bytes);
            }
            case LONG: {
                return Bytes.toLong((byte[])bytes);
            }
            case FLOAT: {
                return Float.valueOf(Bytes.toFloat((byte[])bytes));
            }
            case DOUBLE: {
                return Bytes.toDouble((byte[])bytes);
            }
            case STRING: {
                return Bytes.toString((byte[])bytes);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }
}

