/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.hbase.AbstractHBaseWindowPutOutputOperator;
import com.datatorrent.lib.util.ReusableStringReader;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.hbase.client.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.prefs.CsvPreference;

public class HBaseNameValueCsvPutOperator
extends AbstractHBaseWindowPutOutputOperator<String> {
    private static final transient Logger logger = LoggerFactory.getLogger(HBaseNameValueCsvPutOperator.class);
    @NotNull
    private String mapping;
    private transient String rowKey;
    private transient Map<String, ColDef> colMap = new HashMap<String, ColDef>();
    private transient Map<String, String> linemap = new HashMap<String, String>();
    private transient ICsvListReader lineListReader = null;
    private transient ReusableStringReader lineSr = new ReusableStringReader();
    private transient ArrayList<String> csvLineList = new ArrayList();

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    @Override
    public Put operationPut(String t) {
        return this.parseLine(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseMapping() {
        CsvListReader listReader = null;
        StringReader sr = null;
        ArrayList csvList = new ArrayList();
        try {
            sr = new StringReader(this.mapping);
            listReader = new CsvListReader((Reader)sr, CsvPreference.STANDARD_PREFERENCE);
            csvList = (ArrayList)listReader.read();
        }
        catch (IOException e) {
            logger.error("Cannot read the mapping string", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
        finally {
            try {
                sr.close();
                listReader.close();
            }
            catch (IOException e) {
                logger.error("Error closing Csv reader", (Throwable)e);
                DTThrowable.rethrow((Exception)e);
            }
        }
        for (String pair : csvList) {
            ColDef c = new ColDef();
            if (pair.indexOf(46) != -1) {
                c.colName = pair.substring(pair.indexOf(46) + 1);
                c.colFam = pair.substring(pair.indexOf(61) + 1, pair.indexOf(46));
                this.colMap.put(pair.substring(0, pair.indexOf(61)), c);
                continue;
            }
            this.rowKey = pair.substring(0, pair.indexOf(61));
        }
    }

    public Put parseLine(String s) {
        Put put = null;
        try {
            this.lineSr.open(s);
            this.csvLineList = (ArrayList)this.lineListReader.read();
        }
        catch (IOException e) {
            logger.error("Cannot read the property string", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
        for (String pair : this.csvLineList) {
            String key = pair.substring(0, pair.indexOf(61));
            String value = pair.substring(pair.indexOf(61) + 1);
            if (key.equals(this.rowKey)) {
                put = new Put(value.getBytes());
                for (Map.Entry<String, String> entry : this.linemap.entrySet()) {
                    ColDef c = this.colMap.get(entry.getKey());
                    put.add(c.colFam.getBytes(), c.colName.getBytes(), entry.getValue().getBytes());
                }
                continue;
            }
            if (put != null) {
                ColDef c = this.colMap.get(key);
                put.add(c.colFam.getBytes(), c.colName.getBytes(), value.getBytes());
                continue;
            }
            this.linemap.put(key, value);
        }
        this.csvLineList.clear();
        this.linemap.clear();
        return put;
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.parseMapping();
        this.lineListReader = new CsvListReader((Reader)this.lineSr, CsvPreference.STANDARD_PREFERENCE);
    }

    public void teardown() {
        super.teardown();
        try {
            this.lineSr.close();
            this.lineListReader.close();
        }
        catch (IOException e) {
            logger.error("Cannot close the readers", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    private class ColDef {
        String colFam;
        String colName;

        private ColDef() {
        }
    }
}

