/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.lib.db.Connectable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseStore
implements Connectable {
    public static final String USER_NAME_SPECIFIER = "%USER_NAME%";
    private static final Logger logger = LoggerFactory.getLogger(HBaseStore.class);
    private String zookeeperQuorum;
    private int zookeeperClientPort;
    protected String tableName;
    protected String principal;
    protected String keytabPath;
    protected long reloginCheckInterval = 1800000L;
    protected transient Thread loginRenewer;
    private volatile transient boolean doRelogin;
    protected transient HTable table;
    protected transient Configuration configuration;

    public String getZookeeperQuorum() {
        return this.zookeeperQuorum;
    }

    public void setZookeeperQuorum(String zookeeperQuorum) {
        this.zookeeperQuorum = zookeeperQuorum;
    }

    public int getZookeeperClientPort() {
        return this.zookeeperClientPort;
    }

    public void setZookeeperClientPort(int zookeeperClientPort) {
        this.zookeeperClientPort = zookeeperClientPort;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getKeytabPath() {
        return this.keytabPath;
    }

    public void setKeytabPath(String keytabPath) {
        this.keytabPath = keytabPath;
    }

    public long getReloginCheckInterval() {
        return this.reloginCheckInterval;
    }

    public void setReloginCheckInterval(long reloginCheckInterval) {
        this.reloginCheckInterval = reloginCheckInterval;
    }

    public HTable getTable() {
        return this.table;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void connect() throws IOException {
        if (this.principal != null && this.keytabPath != null) {
            String lprincipal = this.evaluateProperty(this.principal);
            String lkeytabPath = this.evaluateProperty(this.keytabPath);
            UserGroupInformation.loginUserFromKeytab((String)lprincipal, (String)lkeytabPath);
            this.doRelogin = true;
            this.loginRenewer = new Thread(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        logger.debug("Renewer starting");
                        try {
                            while (HBaseStore.this.doRelogin) {
                                Thread.sleep(HBaseStore.this.reloginCheckInterval);
                                try {
                                    UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                                }
                                catch (IOException e) {
                                    logger.error("Error trying to relogin from keytab", (Throwable)e);
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            if (!HBaseStore.this.doRelogin) break block5;
                            logger.warn("Renewer interrupted... stopping");
                        }
                    }
                    logger.debug("Renewer ending");
                }
            });
            this.loginRenewer.start();
        }
        this.configuration = HBaseConfiguration.create();
        if (this.zookeeperQuorum != null) {
            this.configuration.set("hbase.zookeeper.quorum", this.zookeeperQuorum);
        }
        if (this.zookeeperClientPort != 0) {
            this.configuration.set("hbase.zookeeper.property.clientPort", "" + this.zookeeperClientPort);
        }
        this.table = new HTable(this.configuration, this.tableName);
        this.table.setAutoFlushTo(false);
    }

    private String evaluateProperty(String property) throws IOException {
        if (property.contains(USER_NAME_SPECIFIER)) {
            property = property.replaceAll(USER_NAME_SPECIFIER, UserGroupInformation.getLoginUser().getShortUserName());
        }
        return property;
    }

    public void disconnect() throws IOException {
        if (this.loginRenewer != null) {
            this.doRelogin = false;
            this.loginRenewer.interrupt();
            try {
                this.loginRenewer.join();
            }
            catch (InterruptedException e) {
                logger.warn("Unsuccessful waiting for renewer to finish. Proceeding to shutdown", (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return false;
    }
}

