/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.hbase;

import com.datatorrent.contrib.hbase.HBaseStore;
import com.datatorrent.lib.db.TransactionableStore;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseWindowStore
extends HBaseStore
implements TransactionableStore {
    private static final transient Logger logger = LoggerFactory.getLogger(HBaseWindowStore.class);
    private static final String DEFAULT_ROW_NAME = "HBaseOperator_row";
    private static final String DEFAULT_COLUMN_FAMILY_NAME = "HBaseOutputOperator_cf";
    private static final String DEFAULT_LAST_WINDOW_PREFIX_COLUMN_NAME = "last_window";
    private transient String rowName = "HBaseOperator_row";
    private transient String columnFamilyName = "HBaseOutputOperator_cf";
    private transient byte[] rowBytes;
    private transient byte[] columnFamilyBytes;
    private transient String lastWindowColumnName = "last_window";
    private transient byte[] lastWindowColumnBytes;

    public HBaseWindowStore() {
        this.constructKeys();
    }

    private void constructKeys() {
        this.rowBytes = Bytes.toBytes((String)this.rowName);
        this.columnFamilyBytes = Bytes.toBytes((String)this.columnFamilyName);
    }

    public String getRowName() {
        return this.rowName;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
        this.constructKeys();
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public void setColumnFamilyName(String columnFamilyName) {
        this.columnFamilyName = columnFamilyName;
        this.constructKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        super.connect();
        HTableDescriptor tdesc = this.table.getTableDescriptor();
        if (!tdesc.hasFamily(this.columnFamilyBytes)) {
            HBaseAdmin admin = new HBaseAdmin(this.table.getConfiguration());
            admin.disableTable(this.table.getTableName());
            try {
                HColumnDescriptor cdesc = new HColumnDescriptor(this.columnFamilyBytes);
                admin.addColumn(this.table.getTableName(), cdesc);
            }
            finally {
                admin.enableTable(this.table.getTableName());
                admin.close();
            }
        }
    }

    public void beginTransaction() {
    }

    public void commitTransaction() {
    }

    public void rollbackTransaction() {
    }

    public boolean isInTransaction() {
        return false;
    }

    public long getCommittedWindowId(String appId, int operatorId) {
        byte[] value = null;
        try {
            String columnKey = appId + "_" + operatorId + "_" + this.lastWindowColumnName;
            this.lastWindowColumnBytes = Bytes.toBytes((String)columnKey);
            Get get = new Get(this.rowBytes);
            get.addColumn(this.columnFamilyBytes, this.lastWindowColumnBytes);
            Result result = null;
            result = this.table.get(get);
            for (KeyValue kv : result.raw()) {
                if (!kv.matchingQualifier(this.lastWindowColumnBytes)) continue;
                value = kv.getValue();
                break;
            }
        }
        catch (IOException ex) {
            logger.error("Could not load window id ", (Throwable)ex);
            DTThrowable.rethrow((Exception)ex);
        }
        if (value != null) {
            long longval = Bytes.toLong(value);
            return longval;
        }
        return -1L;
    }

    public void storeCommittedWindowId(String appId, int operatorId, long windowId) {
        byte[] WindowIdBytes = Bytes.toBytes((long)windowId);
        String columnKey = appId + "_" + operatorId + "_" + this.lastWindowColumnName;
        this.lastWindowColumnBytes = Bytes.toBytes((String)columnKey);
        Put put = new Put(this.rowBytes);
        put.add(this.columnFamilyBytes, this.lastWindowColumnBytes, WindowIdBytes);
        try {
            this.table.put(put);
        }
        catch (RetriesExhaustedWithDetailsException e) {
            logger.error("Could not store window id ", (Throwable)e);
            DTThrowable.rethrow((Exception)((Object)e));
        }
        catch (InterruptedIOException e) {
            logger.error("Could not store window id ", (Throwable)e);
            DTThrowable.rethrow((Exception)e);
        }
    }

    public void removeCommittedWindowId(String appId, int operatorId) {
    }
}

