/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.memcache;

import com.datatorrent.lib.db.KeyValueStore;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheStore
implements KeyValueStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemcacheStore.class);
    protected transient MemcachedClient memcacheClient;
    private List<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>();
    protected int keyExpiryTime = 0;

    public void addServer(InetSocketAddress addr) {
        this.serverAddresses.add(addr);
    }

    public List<InetSocketAddress> getServerAddresses() {
        return this.serverAddresses;
    }

    public void setServerAddresses(List<InetSocketAddress> serverAddresses) {
        this.serverAddresses = serverAddresses;
    }

    public int getKeyExpiryTime() {
        return this.keyExpiryTime;
    }

    public void setKeyExpiryTime(int keyExpiryTime) {
        this.keyExpiryTime = keyExpiryTime;
    }

    public void connect() throws IOException {
        this.memcacheClient = this.serverAddresses.isEmpty() ? new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress("localhost", 11211)}) : new MemcachedClient(this.serverAddresses);
    }

    public void disconnect() throws IOException {
        this.memcacheClient.shutdown();
    }

    public boolean isConnected() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object get(Object key) {
        return this.memcacheClient.get(key.toString());
    }

    public List<Object> getAll(List<Object> keys) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object key : keys) {
            results.add(this.memcacheClient.get(key.toString()));
        }
        return results;
    }

    public void put(Object key, Object value) {
        try {
            this.memcacheClient.set(key.toString(), this.keyExpiryTime, value).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putAll(Map<Object, Object> m) {
        ArrayList<OperationFuture> futures = new ArrayList<OperationFuture>();
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            futures.add(this.memcacheClient.set(entry.getKey().toString(), this.keyExpiryTime, entry.getValue()));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void remove(Object key) {
        this.memcacheClient.delete(key.toString());
    }
}

