/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.memcache_whalin;

import com.datatorrent.lib.db.KeyValueStore;
import com.whalin.MemCached.MemCachedClient;
import com.whalin.MemCached.SockIOPool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheStore
implements KeyValueStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemcacheStore.class);
    protected transient MemCachedClient memcacheClient;
    protected transient SockIOPool pool;
    private List<String> serverAddresses = new ArrayList<String>();
    protected int keyExpiryTime = 0;

    public void addServer(InetSocketAddress addr) {
        this.serverAddresses.add(addr.getHostName() + ":" + addr.getPort());
    }

    public int getKeyExpiryTime() {
        return this.keyExpiryTime;
    }

    public void setKeyExpiryTime(int keyExpiryTime) {
        this.keyExpiryTime = keyExpiryTime;
    }

    public void connect() throws IOException {
        this.pool = SockIOPool.getInstance();
        if (this.serverAddresses.isEmpty()) {
            this.pool.setServers(new String[]{"localhost:11211"});
        } else {
            this.pool.setServers(this.serverAddresses.toArray(new String[0]));
        }
        this.pool.initialize();
        this.memcacheClient = new MemCachedClient();
    }

    public void disconnect() throws IOException {
        this.pool.shutDown();
    }

    public boolean isConnected() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object get(Object key) {
        return this.memcacheClient.get(key.toString());
    }

    public List<Object> getAll(List<Object> keys) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object key : keys) {
            results.add(this.memcacheClient.get(key.toString()));
        }
        return results;
    }

    public void put(Object key, Object value) {
        try {
            this.memcacheClient.set(key.toString(), value, Integer.valueOf(this.keyExpiryTime));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void putAll(Map<Object, Object> m) {
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            this.memcacheClient.set(entry.getKey().toString(), entry.getValue(), Integer.valueOf(this.keyExpiryTime));
        }
    }

    public void remove(Object key) {
        this.memcacheClient.delete(key.toString());
    }
}

