/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.memsql;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.memsql.AbstractMemsqlInputOperator;
import com.datatorrent.lib.db.jdbc.JdbcStore;
import com.datatorrent.lib.util.PojoUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class MemsqlPOJOInputOperator
extends AbstractMemsqlInputOperator<Object> {
    @Min(value=1L)
    private int batchSize = 10;
    @Min(value=0L)
    private Number startRow = 0;
    @NotNull
    private List<String> expressions;
    @NotNull
    private String tablename;
    @NotNull
    private String primaryKeyColumn;
    @NotNull
    private List<String> columns;
    private transient Number lastRowKey;
    @NotNull
    private String query;
    private static final Map<String, Class<?>> jdbcToJavaType = new HashMap();
    private final transient Map<String, Class<?>> columnNameToClassMapping;
    private final transient List<Object> setters = new ArrayList<Object>();
    private transient Class<?> objectClass = null;
    private transient Class<?> primaryKeyColumnType;
    private String outputClass;
    private static final Logger logger;

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public String getPrimaryKeyColumn() {
        return this.primaryKeyColumn;
    }

    public void setPrimaryKeyColumn(String primaryKeyColumn) {
        this.primaryKeyColumn = primaryKeyColumn;
    }

    public Number getStartRow() {
        return this.startRow;
    }

    public void setStartRow(Number startRow) {
        this.startRow = startRow;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query.replace("%t", this.tablename);
    }

    public List<String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<String> expressions) {
        this.expressions = expressions;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        try {
            Statement statement = ((JdbcStore)this.store).getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery("describe " + this.tablename);
            while (resultSet.next()) {
                String memsqlType = resultSet.getString("Type");
                String javaType = memsqlType.contains("(") ? memsqlType.substring(0, memsqlType.indexOf(40)).toUpperCase() : memsqlType.toUpperCase();
                Class<?> type = jdbcToJavaType.get(javaType);
                String columnNameInTable = resultSet.getString("Field");
                this.columnNameToClassMapping.put(columnNameInTable, type);
                if (!resultSet.getString("Key").equals("PRI")) continue;
                this.primaryKeyColumnType = type;
            }
            if (this.primaryKeyColumnType == null) {
                throw new RuntimeException("Primary Key is not defined on the specified table");
            }
            if (this.query.contains("%p")) {
                this.query = this.query.replace("%p", this.primaryKeyColumn);
            }
            if (this.query.contains("%l")) {
                this.query = this.query.replace("%l", this.batchSize + "");
            }
            statement.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.objectClass = Class.forName(this.outputClass);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            String setterExpression = this.expressions.get(i);
            String columnName = this.columns.get(i);
            this.setters.add(PojoUtils.constructSetter(this.objectClass, (String)setterExpression, this.columnNameToClassMapping.get(columnName)));
        }
    }

    public MemsqlPOJOInputOperator() {
        this.columnNameToClassMapping = new HashMap();
    }

    public Object getTuple(ResultSet result) {
        Object obj;
        block21: {
            try {
                obj = this.objectClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            int size = this.columns.size();
            try {
                for (int i = 0; i < size; ++i) {
                    String columnName = this.columns.get(i);
                    Class<?> classType = this.columnNameToClassMapping.get(columnName);
                    if (classType == String.class) {
                        ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)result.getString(columnName));
                        continue;
                    }
                    if (classType == Integer.TYPE) {
                        ((PojoUtils.SetterInt)this.setters.get(i)).set(obj, result.getInt(columnName));
                        continue;
                    }
                    if (classType == Boolean.class) {
                        ((PojoUtils.SetterBoolean)this.setters.get(i)).set(obj, result.getBoolean(columnName));
                        continue;
                    }
                    if (classType == Short.class) {
                        ((PojoUtils.SetterShort)this.setters.get(i)).set(obj, result.getShort(columnName));
                        continue;
                    }
                    if (classType == Long.class) {
                        ((PojoUtils.SetterLong)this.setters.get(i)).set(obj, result.getLong(columnName));
                        continue;
                    }
                    if (classType == Float.class) {
                        ((PojoUtils.SetterFloat)this.setters.get(i)).set(obj, result.getFloat(columnName));
                        continue;
                    }
                    if (classType == Double.class) {
                        ((PojoUtils.SetterDouble)this.setters.get(i)).set(obj, result.getDouble(columnName));
                        continue;
                    }
                    if (classType == BigDecimal.class) {
                        ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)result.getBigDecimal(columnName));
                        continue;
                    }
                    if (classType == Date.class) {
                        ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)result.getDate(columnName));
                        continue;
                    }
                    if (classType == Timestamp.class) {
                        ((PojoUtils.Setter)this.setters.get(i)).set(obj, (Object)result.getTimestamp(columnName));
                        continue;
                    }
                    throw new RuntimeException("unsupported data type ");
                }
                if (!result.isLast()) break block21;
                logger.debug("last row is {}", (Object)this.lastRowKey);
                if (this.primaryKeyColumnType == Integer.TYPE) {
                    this.lastRowKey = result.getInt(this.primaryKeyColumn);
                    break block21;
                }
                if (this.primaryKeyColumnType == Long.class) {
                    this.lastRowKey = result.getLong(this.primaryKeyColumn);
                    break block21;
                }
                if (this.primaryKeyColumnType == Float.class) {
                    this.lastRowKey = Float.valueOf(result.getFloat(this.primaryKeyColumn));
                    break block21;
                }
                if (this.primaryKeyColumnType == Double.class) {
                    this.lastRowKey = result.getDouble(this.primaryKeyColumn);
                    break block21;
                }
                if (this.primaryKeyColumnType == Short.class) {
                    this.lastRowKey = result.getShort(this.primaryKeyColumn);
                    break block21;
                }
                throw new RuntimeException("unsupported data type ");
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return obj;
    }

    public String queryToRetrieveData() {
        String parameterizedQuery = this.query.contains("%s") ? this.query.replace("%s", this.startRow + "") : this.query;
        return parameterizedQuery;
    }

    public void emitTuples() {
        super.emitTuples();
        this.startRow = this.lastRowKey;
    }

    static {
        jdbcToJavaType.put("VARCHAR", String.class);
        jdbcToJavaType.put("CHAR", String.class);
        jdbcToJavaType.put("LONGTEXT", String.class);
        jdbcToJavaType.put("INT", Integer.TYPE);
        jdbcToJavaType.put("BIGINT", Long.class);
        jdbcToJavaType.put("DATE", Date.class);
        jdbcToJavaType.put("TIME", Time.class);
        jdbcToJavaType.put("TIMESTAMP", Timestamp.class);
        jdbcToJavaType.put("NUMERIC", BigDecimal.class);
        jdbcToJavaType.put("DECIMAL", BigDecimal.class);
        jdbcToJavaType.put("BOOL", Boolean.class);
        jdbcToJavaType.put("TINYINT", Byte.class);
        jdbcToJavaType.put("BIT", Boolean.class);
        jdbcToJavaType.put("SMALLINT", Short.class);
        jdbcToJavaType.put("MEDIUMINT", Short.class);
        jdbcToJavaType.put("DOUBLE", Double.class);
        jdbcToJavaType.put("FLOAT", Float.class);
        logger = LoggerFactory.getLogger(MemsqlPOJOInputOperator.class);
    }
}

