/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.memsql;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.memsql.AbstractMemsqlOutputOperator;
import com.datatorrent.contrib.memsql.MemsqlStore;
import com.datatorrent.lib.util.PojoUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class MemsqlPOJOOutputOperator
extends AbstractMemsqlOutputOperator<Object> {
    private static final long serialVersionUID = 20150618346L;
    @NotNull
    private String tablename;
    @NotNull
    private ArrayList<String> dataColumns;
    @NotNull
    private ArrayList<String> expression;
    private final ArrayList<Integer> columnDataTypes = new ArrayList();
    private transient boolean isFirstTuple;
    private final transient ArrayList<Object> getters = new ArrayList();
    private String insertStatement;
    private static final transient Logger LOG = LoggerFactory.getLogger(MemsqlPOJOOutputOperator.class);

    public ArrayList<String> getExpression() {
        return this.expression;
    }

    public void setExpression(ArrayList<String> expression) {
        this.expression = expression;
    }

    public ArrayList<String> getDataColumns() {
        return this.dataColumns;
    }

    public void setDataColumns(ArrayList<String> dataColumns) {
        this.dataColumns = dataColumns;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void setup(Context.OperatorContext context) {
        this.isFirstTuple = true;
        StringBuilder columns = new StringBuilder("");
        StringBuilder values = new StringBuilder("");
        for (int i = 0; i < this.dataColumns.size(); ++i) {
            columns.append(this.dataColumns.get(i));
            values.append("?");
            if (i >= this.dataColumns.size() - 1) continue;
            columns.append(",");
            values.append(",");
        }
        this.insertStatement = "INSERT INTO " + this.tablename + " (" + columns.toString() + ")" + " VALUES (" + values.toString() + ")";
        super.setup(context);
        Connection conn = ((MemsqlStore)this.store).getConnection();
        LOG.debug("Got Connection.");
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery("select * from " + this.tablename);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int numberOfColumns = rsMetaData.getColumnCount();
            LOG.debug("resultSet MetaData column Count=" + numberOfColumns);
            for (int i = 1; i <= numberOfColumns; ++i) {
                int type = rsMetaData.getColumnType(i);
                this.columnDataTypes.add(type);
                LOG.debug("sql column type is " + type);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void processTuple(Object tuple) {
        if (this.isFirstTuple) {
            this.processFirstTuple(tuple);
        }
        this.isFirstTuple = false;
        super.processTuple(tuple);
    }

    public void processFirstTuple(Object tuple) {
        Class<?> fqcn = tuple.getClass();
        int size = this.columnDataTypes.size();
        for (int i = 0; i < size; ++i) {
            PojoUtils.GetterChar getter;
            int type = this.columnDataTypes.get(i);
            String getterExpression = this.expression.get(i);
            switch (type) {
                case 1: {
                    getter = PojoUtils.createGetterChar(fqcn, (String)getterExpression);
                    break;
                }
                case 12: {
                    getter = PojoUtils.createGetter(fqcn, (String)getterExpression, String.class);
                    break;
                }
                case -6: 
                case 16: {
                    getter = PojoUtils.createGetterBoolean(fqcn, (String)getterExpression);
                    break;
                }
                case 5: {
                    getter = PojoUtils.createGetterShort(fqcn, (String)getterExpression);
                    break;
                }
                case 4: {
                    getter = PojoUtils.createGetterInt(fqcn, (String)getterExpression);
                    break;
                }
                case -5: {
                    getter = PojoUtils.createGetterLong(fqcn, (String)getterExpression);
                    break;
                }
                case 6: {
                    getter = PojoUtils.createGetterFloat(fqcn, (String)getterExpression);
                    break;
                }
                case 8: {
                    getter = PojoUtils.createGetterDouble(fqcn, (String)getterExpression);
                    break;
                }
                default: {
                    getter = PojoUtils.createGetter(fqcn, (String)getterExpression, Object.class);
                }
            }
            this.getters.add(getter);
        }
    }

    protected String getUpdateCommand() {
        LOG.debug("insertstatement is {}", (Object)this.insertStatement);
        return this.insertStatement;
    }

    protected void setStatementParameters(PreparedStatement statement, Object tuple) throws SQLException {
        int size = this.columnDataTypes.size();
        block10: for (int i = 0; i < size; ++i) {
            int type = this.columnDataTypes.get(i);
            switch (type) {
                case 1: {
                    statement.setInt(i + 1, ((PojoUtils.GetterChar)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                case 12: {
                    statement.setString(i + 1, (String)((PojoUtils.Getter)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                case -6: 
                case 16: {
                    statement.setBoolean(i + 1, ((PojoUtils.GetterBoolean)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                case 5: {
                    statement.setShort(i + 1, ((PojoUtils.GetterShort)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                case 4: {
                    statement.setInt(i + 1, ((PojoUtils.GetterInt)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                case -5: {
                    statement.setLong(i + 1, ((PojoUtils.GetterLong)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                case 6: {
                    statement.setFloat(i + 1, ((PojoUtils.GetterFloat)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                case 8: {
                    statement.setDouble(i + 1, ((PojoUtils.GetterDouble)this.getters.get(i)).get(tuple));
                    continue block10;
                }
                default: {
                    statement.setObject(i + 1, ((PojoUtils.Getter)this.getters.get(i)).get(tuple));
                }
            }
        }
    }
}

