/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.mongodb;

import com.datatorrent.lib.db.Connectable;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import java.net.UnknownHostException;
import javax.validation.constraints.NotNull;

public class MongoDBConnectable
implements Connectable {
    @NotNull
    protected String hostName;
    protected String dataBase;
    protected String userName;
    protected String passWord;
    protected transient MongoClient mongoClient;
    protected transient DB db;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(String dataBase) {
        this.dataBase = dataBase;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String dbUrl) {
        this.hostName = dbUrl;
    }

    public void connect() {
        try {
            this.mongoClient = new MongoClient(this.hostName);
            this.db = this.mongoClient.getDB(this.dataBase);
            if (this.userName != null && this.passWord != null) {
                this.db.authenticate(this.userName, this.passWord.toCharArray());
            }
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException("creating mongodb client", ex);
        }
    }

    public void disconnect() {
        this.mongoClient.close();
    }

    public boolean isConnected() {
        try {
            this.mongoClient.getConnector().getDBPortPool(this.mongoClient.getAddress()).get().ensureOpen();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

