/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.mongodb;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.mongodb.MongoDBConnectable;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MongoDBInputOperator<T>
extends MongoDBConnectable
implements InputOperator,
Operator.ActivationListener<Context.OperatorContext> {
    private static final Logger logger = LoggerFactory.getLogger(MongoDBInputOperator.class);
    private String table;
    private DBObject query;
    private transient DBCursor resultCursor;
    public final transient DefaultOutputPort<T> outputPort = new DefaultOutputPort();

    public abstract T getTuple(DBCursor var1);

    public void emitTuples() {
        this.resultCursor = this.db.getCollection(this.table).find(this.query);
        this.outputPort.emit(this.getTuple(this.resultCursor));
    }

    public void beginWindow(long windowId) {
        try {
            this.mongoClient = new MongoClient(this.hostName);
            this.db = this.mongoClient.getDB(this.dataBase);
            if (this.userName != null && this.passWord != null) {
                this.db.authenticate(this.userName, this.passWord.toCharArray());
            }
        }
        catch (UnknownHostException ex) {
            logger.debug(ex.toString());
        }
    }

    public void endWindow() {
    }

    public void setup(Context.OperatorContext context) {
    }

    public void teardown() {
    }

    public void activate(Context.OperatorContext ctx) {
    }

    public void deactivate() {
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public void setQuery(DBObject query) {
        this.query = query;
    }
}

