/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.nifi;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.contrib.nifi.AbstractNiFiOutputOperator;
import com.datatorrent.contrib.nifi.NiFiDataPacketBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.apex.malhar.lib.wal.WindowDataManager;
import org.apache.nifi.remote.client.SiteToSiteClient;

public class NiFiSinglePortOutputOperator<T>
extends AbstractNiFiOutputOperator<T> {
    public final transient BufferingInputPort inputPort;

    private NiFiSinglePortOutputOperator() {
        this(null, null, null, 0);
    }

    public NiFiSinglePortOutputOperator(SiteToSiteClient.Builder siteToSiteBuilder, NiFiDataPacketBuilder<T> dataPacketBuilder, WindowDataManager windowDataManager, int batchSize) {
        super(siteToSiteBuilder, dataPacketBuilder, windowDataManager);
        this.inputPort = new BufferingInputPort(batchSize);
    }

    @Override
    protected void endNewWindow() {
        this.inputPort.flush();
    }

    public class BufferingInputPort
    extends DefaultInputPort<T> {
        private final int batchSize;
        private final List<T> tuples = new ArrayList();

        public BufferingInputPort(int batchSize) {
            this.batchSize = batchSize;
        }

        public void process(T tuple) {
            if (!NiFiSinglePortOutputOperator.this.skipProcessingTuple) {
                this.tuples.add(tuple);
                if (this.tuples.size() >= this.batchSize) {
                    this.flush();
                }
            }
        }

        public void flush() {
            NiFiSinglePortOutputOperator.this.processTuples(this.tuples);
            this.tuples.clear();
        }
    }
}

