/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parquet;

import com.datatorrent.api.Context;
import com.datatorrent.lib.io.fs.AbstractFileInputOperator;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;
import parquet.example.data.Group;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.example.GroupReadSupport;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public abstract class AbstractParquetFileReader<T>
extends AbstractFileInputOperator<T> {
    private transient ParquetReader<Group> reader;
    protected transient MessageType schema;
    protected String parquetSchema;

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.schema = MessageTypeParser.parseMessageType((String)this.parquetSchema);
    }

    protected InputStream openFile(Path path) throws IOException {
        InputStream is = super.openFile(path);
        GroupReadSupport readSupport = new GroupReadSupport();
        readSupport.init(this.configuration, null, this.schema);
        this.reader = new ParquetReader(path, (ReadSupport)readSupport);
        return is;
    }

    protected T readEntity() throws IOException {
        Group group = (Group)this.reader.read();
        if (group != null) {
            return this.convertGroup(group);
        }
        return null;
    }

    protected abstract T convertGroup(Group var1);

    public String getParquetSchema() {
        return this.parquetSchema;
    }

    public void setParquetSchema(String parquetSchema) {
        this.parquetSchema = parquetSchema;
    }
}

