/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parquet;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.contrib.parquet.AbstractParquetFileReader;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.PojoUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.example.data.Group;
import parquet.io.InvalidRecordException;
import parquet.io.ParquetEncodingException;
import parquet.schema.PrimitiveType;

public class ParquetFilePOJOReader
extends AbstractParquetFileReader<Object> {
    protected transient Class<?> pojoClass;
    protected transient String parquetToPOJOFieldsMapping = null;
    protected transient List<ActiveFieldInfo> activeFieldInfos = null;
    protected static final String FIELD_SEPARATOR = ":";
    protected static final String RECORD_SEPARATOR = ",";
    private static final Logger logger = LoggerFactory.getLogger(ParquetFilePOJOReader.class);
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> output = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            ParquetFilePOJOReader.this.pojoClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
            if (ParquetFilePOJOReader.this.parquetToPOJOFieldsMapping == null) {
                ParquetFilePOJOReader.this.initialiseActiveFieldInfo(ParquetFilePOJOReader.this.generateFieldInfoInputs());
            } else {
                ParquetFilePOJOReader.this.initialiseActiveFieldInfo(ParquetFilePOJOReader.this.parquetToPOJOFieldsMapping);
            }
        }
    };

    @Override
    protected Object convertGroup(Group group) {
        Object obj;
        try {
            obj = this.pojoClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        for (int i = 0; i < this.activeFieldInfos.size(); ++i) {
            try {
                ActiveFieldInfo afi = this.activeFieldInfos.get(i);
                switch (afi.primitiveTypeName) {
                    case BOOLEAN: {
                        Boolean booleanVal = Boolean.parseBoolean(group.getValueToString(afi.fieldIndex, 0));
                        ((PojoUtils.SetterBoolean)afi.setter).set(obj, booleanVal.booleanValue());
                        break;
                    }
                    case INT32: {
                        Integer intVal = Integer.parseInt(group.getValueToString(afi.fieldIndex, 0));
                        ((PojoUtils.SetterInt)afi.setter).set(obj, intVal.intValue());
                        break;
                    }
                    case INT64: {
                        Long longVal = Long.parseLong(group.getValueToString(afi.fieldIndex, 0));
                        ((PojoUtils.SetterLong)afi.setter).set(obj, longVal.longValue());
                        break;
                    }
                    case FLOAT: {
                        Float floatVal = Float.valueOf(Float.parseFloat(group.getValueToString(afi.fieldIndex, 0)));
                        ((PojoUtils.SetterFloat)afi.setter).set(obj, floatVal.floatValue());
                        break;
                    }
                    case DOUBLE: {
                        Double doubleVal = Double.parseDouble(group.getValueToString(afi.fieldIndex, 0));
                        ((PojoUtils.SetterDouble)afi.setter).set(obj, doubleVal.doubleValue());
                        break;
                    }
                    case BINARY: {
                        ((PojoUtils.Setter)afi.setter).set(obj, (Object)group.getValueToString(afi.fieldIndex, 0));
                        break;
                    }
                    default: {
                        throw new ParquetEncodingException("Unsupported column type: " + afi.primitiveTypeName);
                    }
                }
                continue;
            }
            catch (InvalidRecordException e) {
                logger.error("Field not found in schema {} ", (Throwable)e);
            }
        }
        return obj;
    }

    protected void emit(Object tuple) {
        this.output.emit(tuple);
    }

    private void initialiseActiveFieldInfo(String fieldMapping) {
        String[] fields = fieldMapping.split(RECORD_SEPARATOR);
        this.activeFieldInfos = new ArrayList<ActiveFieldInfo>(fields.length);
        for (String field : fields) {
            String[] token = field.split(FIELD_SEPARATOR);
            try {
                int fieldIndex = this.schema.getFieldIndex(token[0]);
                PrimitiveType.PrimitiveTypeName primitiveTypeName = this.schema.getType(fieldIndex).asPrimitiveType().getPrimitiveTypeName();
                this.activeFieldInfos.add(new ActiveFieldInfo(this.getSetter(token[1], FieldInfo.SupportType.valueOf((String)token[2])), primitiveTypeName, fieldIndex));
            }
            catch (InvalidRecordException e) {
                logger.error("{} not present in schema ", (Object)token[0]);
            }
            catch (UnsupportedOperationException e) {
                logger.error("{} not yet supported ", (Object)e.getMessage());
            }
        }
    }

    private Object getSetter(String pojoFieldExpression, FieldInfo.SupportType supportType) throws UnsupportedOperationException {
        switch (supportType) {
            case BOOLEAN: {
                return PojoUtils.createSetterBoolean(this.pojoClass, (String)pojoFieldExpression);
            }
            case DOUBLE: {
                return PojoUtils.createSetterDouble(this.pojoClass, (String)pojoFieldExpression);
            }
            case FLOAT: {
                return PojoUtils.createSetterFloat(this.pojoClass, (String)pojoFieldExpression);
            }
            case INTEGER: {
                return PojoUtils.createSetterInt(this.pojoClass, (String)pojoFieldExpression);
            }
            case LONG: {
                return PojoUtils.createSetterLong(this.pojoClass, (String)pojoFieldExpression);
            }
            case STRING: {
                return PojoUtils.createSetter(this.pojoClass, (String)pojoFieldExpression, String.class);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type" + supportType);
    }

    public String getParquetToPOJOFieldsMapping() {
        return this.parquetToPOJOFieldsMapping;
    }

    public void setParquetToPOJOFieldsMapping(String parquetToPOJOFieldsMapping) {
        this.parquetToPOJOFieldsMapping = parquetToPOJOFieldsMapping;
    }

    private String generateFieldInfoInputs() {
        Field[] fields = this.pojoClass.getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Class c = ClassUtils.primitiveToWrapper(f.getType());
            sb.append(f.getName() + FIELD_SEPARATOR + f.getName() + FIELD_SEPARATOR + c.getSimpleName().toUpperCase() + RECORD_SEPARATOR);
        }
        return sb.substring(0, sb.length() - 1);
    }

    protected static class ActiveFieldInfo {
        Object setter;
        PrimitiveType.PrimitiveTypeName primitiveTypeName;
        int fieldIndex;

        ActiveFieldInfo(Object setter, PrimitiveType.PrimitiveTypeName primitiveTypeName, int fieldIndex) {
            this.setter = setter;
            this.primitiveTypeName = primitiveTypeName;
            this.fieldIndex = fieldIndex;
        }
    }
}

