/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parser;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.util.ReusableStringReader;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseChar;
import org.supercsv.cellprocessor.ParseDate;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.ICsvReader;
import org.supercsv.prefs.CsvPreference;

public abstract class AbstractCsvParser<T>
extends BaseOperator {
    private ArrayList<Field> fields;
    protected String inputEncoding = "UTF8";
    @NotNull
    protected int fieldDelimiter = 44;
    protected String lineDelimiter = "\r\n";
    protected String fieldmappingFile;
    protected String fieldmappingFileDelimiter = ":";
    protected transient String[] properties;
    protected transient CellProcessor[] processors;
    protected boolean hasHeader = false;
    private transient ICsvReader csvReader;
    @NotNull
    private transient ReusableStringReader csvStringReader = new ReusableStringReader();
    public final transient DefaultOutputPort<T> output = new DefaultOutputPort();
    public final transient DefaultInputPort<byte[]> input = new DefaultInputPort<byte[]>(){

        public void process(byte[] tuple) {
            try {
                Object data;
                AbstractCsvParser.this.csvStringReader.open(new String(tuple, AbstractCsvParser.this.inputEncoding));
                if (AbstractCsvParser.this.hasHeader) {
                    String[] header = AbstractCsvParser.this.csvReader.getHeader(true);
                    int len = header.length;
                    for (int i = 0; i < len; ++i) {
                        logger.debug("header is {}", (Object)header[i]);
                        String headerData = header[i];
                        AbstractCsvParser.this.output.emit((Object)headerData);
                    }
                }
                while ((data = AbstractCsvParser.this.readData(AbstractCsvParser.this.properties, AbstractCsvParser.this.processors)) != null) {
                    logger.debug("data in loop is {}", (Object)data.toString());
                    AbstractCsvParser.this.output.emit(data);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(AbstractCsvParser.class);

    public AbstractCsvParser() {
        this.fields = new ArrayList();
    }

    public void setup(Context.OperatorContext context) {
        if (this.fieldmappingFile != null) {
            Configuration conf = new Configuration();
            try {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Path filepath = new Path(this.fieldmappingFile);
                if (fs.exists(filepath)) {
                    String str;
                    BufferedReader bfr = new BufferedReader(new InputStreamReader((InputStream)fs.open(filepath)));
                    while ((str = bfr.readLine()) != null) {
                        logger.debug("string is {}", (Object)str);
                        String[] temp = str.split(this.fieldmappingFileDelimiter);
                        Field field = new Field();
                        field.setName(temp[0]);
                        field.setType(temp[1]);
                        this.getFields().add(field);
                    }
                } else {
                    logger.debug("File containing fields and their data types does not exist.Please specify the fields and data type through properties of this operator.");
                }
            }
            catch (IOException ex) {
                DTThrowable.rethrow((Exception)ex);
            }
        }
        int countKeyValue = this.getFields().size();
        this.properties = new String[countKeyValue];
        this.processors = new CellProcessor[countKeyValue];
        this.initialise(this.properties, this.processors);
        CsvPreference preference = new CsvPreference.Builder('\"', this.fieldDelimiter, this.lineDelimiter).build();
        this.csvReader = this.getReader(this.csvStringReader, preference);
    }

    public void initialise(String[] properties, CellProcessor[] processors) {
        for (int i = 0; i < this.getFields().size(); ++i) {
            FIELD_TYPE type = this.getFields().get((int)i).type;
            properties[i] = this.getFields().get((int)i).name;
            if (type == FIELD_TYPE.DOUBLE) {
                processors[i] = new Optional((CellProcessor)new ParseDouble());
                continue;
            }
            if (type == FIELD_TYPE.INTEGER) {
                processors[i] = new Optional((CellProcessor)new ParseInt());
                continue;
            }
            if (type == FIELD_TYPE.FLOAT) {
                processors[i] = new Optional((CellProcessor)new ParseDouble());
                continue;
            }
            if (type == FIELD_TYPE.LONG) {
                processors[i] = new Optional((CellProcessor)new ParseLong());
                continue;
            }
            if (type == FIELD_TYPE.SHORT) {
                processors[i] = new Optional((CellProcessor)new ParseInt());
                continue;
            }
            if (type == FIELD_TYPE.STRING) {
                processors[i] = new Optional();
                continue;
            }
            if (type == FIELD_TYPE.CHARACTER) {
                processors[i] = new Optional((CellProcessor)new ParseChar());
                continue;
            }
            if (type == FIELD_TYPE.BOOLEAN) {
                processors[i] = new Optional((CellProcessor)new ParseChar());
                continue;
            }
            if (type != FIELD_TYPE.DATE) continue;
            processors[i] = new Optional((CellProcessor)new ParseDate("dd/MM/yyyy"));
        }
    }

    public void teardown() {
        try {
            this.csvReader.close();
        }
        catch (IOException e) {
            DTThrowable.rethrow((Exception)e);
        }
    }

    protected abstract ICsvReader getReader(ReusableStringReader var1, CsvPreference var2);

    protected abstract T readData(String[] var1, CellProcessor[] var2);

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public int getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(int fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public void setFields(ArrayList<Field> fields) {
        this.fields = fields;
    }

    public String getFieldmappingFile() {
        return this.fieldmappingFile;
    }

    public void setFieldmappingFile(String fieldmappingFile) {
        this.fieldmappingFile = fieldmappingFile;
    }

    public String getFieldmappingFileDelimiter() {
        return this.fieldmappingFileDelimiter;
    }

    public void setFieldmappingFileDelimiter(String fieldmappingFileDelimiter) {
        this.fieldmappingFileDelimiter = fieldmappingFileDelimiter;
    }

    public static class Field {
        String name;
        FIELD_TYPE type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FIELD_TYPE getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = FIELD_TYPE.valueOf(type);
        }
    }

    public static enum FIELD_TYPE {
        BOOLEAN,
        DOUBLE,
        INTEGER,
        FLOAT,
        LONG,
        SHORT,
        CHARACTER,
        STRING,
        DATE;

    }
}

