/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parser;

import com.datatorrent.contrib.parser.DelimitedSchema;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseChar;
import org.supercsv.cellprocessor.ParseDate;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.constraint.DMinMax;
import org.supercsv.cellprocessor.constraint.Equals;
import org.supercsv.cellprocessor.constraint.LMinMax;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.constraint.StrRegEx;
import org.supercsv.cellprocessor.constraint.Strlen;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.util.CsvContext;

public class CellProcessorBuilder {
    public static CellProcessor getCellProcessor(DelimitedSchema.FieldType fieldType, Map<String, Object> constraints) {
        switch (fieldType) {
            case STRING: {
                return CellProcessorBuilder.getStringCellProcessor(constraints);
            }
            case INTEGER: {
                return CellProcessorBuilder.getIntegerCellProcessor(constraints);
            }
            case LONG: {
                return CellProcessorBuilder.getLongCellProcessor(constraints);
            }
            case FLOAT: 
            case DOUBLE: {
                return CellProcessorBuilder.getDoubleCellProcessor(constraints);
            }
            case CHARACTER: {
                return CellProcessorBuilder.getCharCellProcessor(constraints);
            }
            case BOOLEAN: {
                return CellProcessorBuilder.getBooleanCellProcessor(constraints);
            }
            case DATE: {
                return CellProcessorBuilder.getDateCellProcessor(constraints);
            }
        }
        return null;
    }

    private static CellProcessor getStringCellProcessor(Map<String, Object> constraints) {
        Boolean required = constraints.get("required") == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)constraints.get("required")));
        Integer strLen = constraints.get("length") == null ? null : Integer.valueOf(Integer.parseInt((String)constraints.get("length")));
        Integer minLength = constraints.get("minLength") == null ? null : Integer.valueOf(Integer.parseInt((String)constraints.get("minLength")));
        Integer maxLength = constraints.get("maxLength") == null ? null : Integer.valueOf(Integer.parseInt((String)constraints.get("maxLength")));
        String equals = constraints.get("equals") == null ? null : (String)constraints.get("equals");
        String pattern = constraints.get("pattern") == null ? null : (String)constraints.get("pattern");
        Equals cellProcessor = null;
        if (StringUtils.isNotBlank((CharSequence)equals)) {
            cellProcessor = new Equals((Object)equals);
        } else if (StringUtils.isNotBlank((CharSequence)pattern)) {
            cellProcessor = new StrRegEx(pattern);
        } else if (strLen != null) {
            cellProcessor = new Strlen(new int[]{strLen});
        } else if (maxLength != null || minLength != null) {
            Long min = minLength == null ? 0L : (long)minLength.intValue();
            Long max = maxLength == null ? Long.MAX_VALUE : (long)maxLength.intValue();
            cellProcessor = new StrMinMax(min.longValue(), max.longValue());
        }
        if (required == null || !required.booleanValue()) {
            cellProcessor = CellProcessorBuilder.addOptional((CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    private static CellProcessor getIntegerCellProcessor(Map<String, Object> constraints) {
        Boolean required = constraints.get("required") == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)constraints.get("required")));
        Integer equals = constraints.get("equals") == null ? null : Integer.valueOf(Integer.parseInt((String)constraints.get("equals")));
        Integer minValue = constraints.get("minValue") == null ? null : Integer.valueOf(Integer.parseInt((String)constraints.get("minValue")));
        Integer maxValue = constraints.get("maxValue") == null ? null : Integer.valueOf(Integer.parseInt((String)constraints.get("maxValue")));
        Equals cellProcessor = null;
        if (equals != null) {
            cellProcessor = new Equals((Object)equals);
            cellProcessor = CellProcessorBuilder.addParseInt((CellProcessor)cellProcessor);
        } else {
            cellProcessor = minValue != null || maxValue != null ? CellProcessorBuilder.addIntMinMax(minValue, maxValue) : CellProcessorBuilder.addParseInt(null);
        }
        if (required == null || !required.booleanValue()) {
            cellProcessor = CellProcessorBuilder.addOptional((CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    private static CellProcessor getLongCellProcessor(Map<String, Object> constraints) {
        Boolean required = constraints.get("required") == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)constraints.get("required")));
        Long equals = constraints.get("equals") == null ? null : Long.valueOf(Long.parseLong((String)constraints.get("equals")));
        Long minValue = constraints.get("minValue") == null ? null : Long.valueOf(Long.parseLong((String)constraints.get("minValue")));
        Long maxValue = constraints.get("maxValue") == null ? null : Long.valueOf(Long.parseLong((String)constraints.get("maxValue")));
        Equals cellProcessor = null;
        if (equals != null) {
            cellProcessor = new Equals((Object)equals);
            cellProcessor = CellProcessorBuilder.addParseLong((CellProcessor)cellProcessor);
        } else {
            cellProcessor = minValue != null || maxValue != null ? CellProcessorBuilder.addLongMinMax(minValue, maxValue) : CellProcessorBuilder.addParseLong(null);
        }
        if (required == null || !required.booleanValue()) {
            cellProcessor = CellProcessorBuilder.addOptional((CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    private static CellProcessor getDoubleCellProcessor(Map<String, Object> constraints) {
        Boolean required = constraints.get("required") == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)constraints.get("required")));
        Double equals = constraints.get("equals") == null ? null : Double.valueOf(Double.parseDouble((String)constraints.get("equals")));
        Double minValue = constraints.get("minValue") == null ? null : Double.valueOf(Double.parseDouble((String)constraints.get("minValue")));
        Double maxValue = constraints.get("maxValue") == null ? null : Double.valueOf(Double.parseDouble((String)constraints.get("maxValue")));
        Equals cellProcessor = null;
        if (equals != null) {
            cellProcessor = new Equals((Object)equals);
            cellProcessor = CellProcessorBuilder.addParseDouble((CellProcessor)cellProcessor);
        } else {
            cellProcessor = minValue != null || maxValue != null ? CellProcessorBuilder.addDoubleMinMax(minValue, maxValue) : CellProcessorBuilder.addParseDouble(null);
        }
        if (required == null || !required.booleanValue()) {
            cellProcessor = CellProcessorBuilder.addOptional((CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    private static CellProcessor getBooleanCellProcessor(Map<String, Object> constraints) {
        Boolean required = constraints.get("required") == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)constraints.get("required")));
        String trueValue = constraints.get("trueValue") == null ? null : (String)constraints.get("trueValue");
        String falseValue = constraints.get("falseValue") == null ? null : (String)constraints.get("falseValue");
        ParseBool cellProcessor = null;
        cellProcessor = StringUtils.isNotBlank((CharSequence)trueValue) && StringUtils.isNotBlank((CharSequence)falseValue) ? new ParseBool(trueValue, falseValue) : new ParseBool();
        if (required == null || !required.booleanValue()) {
            cellProcessor = CellProcessorBuilder.addOptional((CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    private static CellProcessor getDateCellProcessor(Map<String, Object> constraints) {
        Boolean required = constraints.get("required") == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)constraints.get("required")));
        String format = constraints.get("format") == null ? null : (String)constraints.get("format");
        ParseDate cellProcessor = null;
        String fmt = StringUtils.isNotBlank((CharSequence)format) ? format : "dd/MM/yyyy";
        cellProcessor = new ParseDate(fmt, false);
        if (required == null || !required.booleanValue()) {
            cellProcessor = CellProcessorBuilder.addOptional((CellProcessor)cellProcessor);
        }
        return cellProcessor;
    }

    private static CellProcessor getCharCellProcessor(Map<String, Object> constraints) {
        Boolean required = constraints.get("required") == null ? null : Boolean.valueOf(Boolean.parseBoolean((String)constraints.get("required")));
        Character equals = constraints.get("equals") == null ? null : Character.valueOf(((String)constraints.get("equals")).charAt(0));
        CellProcessor cellProcessor = null;
        if (equals != null) {
            cellProcessor = new Equals((Object)equals);
        }
        cellProcessor = CellProcessorBuilder.addParseChar(cellProcessor);
        if (required == null || !required.booleanValue()) {
            cellProcessor = CellProcessorBuilder.addOptional(cellProcessor);
        }
        return cellProcessor;
    }

    private static CellProcessor addDoubleMinMax(Double minValue, Double maxValue) {
        Double min = minValue == null ? Double.MIN_VALUE : minValue;
        Double max = maxValue == null ? Double.MAX_VALUE : maxValue;
        return new DMinMax(min.doubleValue(), max.doubleValue());
    }

    private static CellProcessor addLongMinMax(Long minValue, Long maxValue) {
        Long min = minValue == null ? Long.MIN_VALUE : minValue;
        Long max = maxValue == null ? Long.MAX_VALUE : maxValue;
        return new LMinMax(min.longValue(), max.longValue());
    }

    private static CellProcessor addIntMinMax(Integer minValue, Integer maxValue) {
        Integer min = minValue == null ? Integer.MIN_VALUE : minValue;
        Integer max = maxValue == null ? Integer.MAX_VALUE : maxValue;
        return new IntMinMax(min, max);
    }

    private static CellProcessor addOptional(CellProcessor cellProcessor) {
        if (cellProcessor == null) {
            return new Optional();
        }
        return new Optional(cellProcessor);
    }

    private static CellProcessor addParseInt(CellProcessor cellProcessor) {
        if (cellProcessor == null) {
            return new ParseInt();
        }
        return new ParseInt((LongCellProcessor)cellProcessor);
    }

    private static CellProcessor addParseLong(CellProcessor cellProcessor) {
        if (cellProcessor == null) {
            return new ParseLong();
        }
        return new ParseLong((LongCellProcessor)cellProcessor);
    }

    private static CellProcessor addParseDouble(CellProcessor cellProcessor) {
        if (cellProcessor == null) {
            return new ParseDouble();
        }
        return new ParseDouble((DoubleCellProcessor)cellProcessor);
    }

    private static CellProcessor addParseChar(CellProcessor cellProcessor) {
        if (cellProcessor == null) {
            return new ParseChar();
        }
        return new ParseChar((DoubleCellProcessor)cellProcessor);
    }

    private static class IntMinMax
    extends LMinMax {
        public IntMinMax(int min, int max) {
            super((long)min, (long)max);
        }

        public Object execute(Object value, CsvContext context) {
            Long result = (Long)super.execute(value, context);
            return result.intValue();
        }
    }
}

