/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parser;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.contrib.parser.CellProcessorBuilder;
import com.datatorrent.contrib.parser.DelimitedSchema;
import com.datatorrent.lib.parser.Parser;
import com.datatorrent.lib.util.KeyValPair;
import com.datatorrent.lib.util.ReusableStringReader;
import com.datatorrent.netlet.util.DTThrowable;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.io.CsvBeanReader;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

@InterfaceStability.Evolving
public class CsvParser
extends Parser<byte[], KeyValPair<String, String>> {
    private transient CsvMapReader csvMapReader;
    private transient CsvBeanReader csvBeanReader;
    private transient ReusableStringReader csvStringReader;
    @NotNull
    private String schema;
    private transient DelimitedSchema delimitedParserSchema;
    private transient CellProcessor[] processors;
    private transient String[] nameMapping;
    private transient String header;
    private transient CsvPreference preference;
    @AutoMetric
    long parsedOutputCount;
    public final transient DefaultOutputPort<Map<String, Object>> parsedOutput = new DefaultOutputPort();
    private static final Logger logger = LoggerFactory.getLogger(CsvParser.class);

    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.parsedOutputCount = 0L;
    }

    public void setup(Context.OperatorContext context) {
        this.delimitedParserSchema = new DelimitedSchema(this.schema);
        this.preference = new CsvPreference.Builder(this.delimitedParserSchema.getQuoteChar(), this.delimitedParserSchema.getDelimiterChar(), this.delimitedParserSchema.getLineDelimiter()).build();
        this.nameMapping = this.delimitedParserSchema.getFieldNames().toArray(new String[this.delimitedParserSchema.getFieldNames().size()]);
        this.header = StringUtils.join((Object[])this.nameMapping, (String)((char)this.delimitedParserSchema.getDelimiterChar() + ""));
        this.processors = this.getProcessor(this.delimitedParserSchema.getFields());
        this.csvStringReader = new ReusableStringReader();
        this.csvMapReader = new CsvMapReader((Reader)this.csvStringReader, this.preference);
        this.csvBeanReader = new CsvBeanReader((Reader)this.csvStringReader, this.preference);
    }

    public Object convert(byte[] tuple) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void processTuple(byte[] tuple) {
        if (tuple == null) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair(null, (Object)"Blank/null tuple"));
            }
            ++this.errorTupleCount;
            return;
        }
        String incomingString = new String(tuple);
        if (StringUtils.isBlank((String)incomingString) || StringUtils.equals((String)incomingString, (String)this.header)) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)"Blank/header tuple"));
            }
            ++this.errorTupleCount;
            return;
        }
        try {
            if (this.parsedOutput.isConnected()) {
                this.csvStringReader.open(incomingString);
                Map map = this.csvMapReader.read(this.nameMapping, this.processors);
                this.parsedOutput.emit((Object)map);
                ++this.parsedOutputCount;
            }
            if (this.out.isConnected() && this.clazz != null) {
                this.csvStringReader.open(incomingString);
                Object obj = this.csvBeanReader.read(this.clazz, this.nameMapping, this.processors);
                this.out.emit(obj);
                ++this.emittedObjectCount;
            }
        }
        catch (IOException | IllegalArgumentException | SuperCsvException e) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)incomingString, (Object)e.getMessage()));
            }
            ++this.errorTupleCount;
            logger.error("Tuple could not be parsed. Reason {}", (Object)e.getMessage());
        }
    }

    public KeyValPair<String, String> processErrorTuple(byte[] input) {
        throw new UnsupportedOperationException("Not supported");
    }

    private CellProcessor[] getProcessor(List<DelimitedSchema.Field> fields) {
        CellProcessor[] processor = new CellProcessor[fields.size()];
        int fieldCount = 0;
        for (DelimitedSchema.Field field : fields) {
            processor[fieldCount++] = CellProcessorBuilder.getCellProcessor(field.getType(), field.getConstraints());
        }
        return processor;
    }

    public void teardown() {
        try {
            this.csvMapReader.close();
        }
        catch (IOException e) {
            logger.error("Error while closing csv map reader {}", (Object)e.getMessage());
            DTThrowable.wrapIfChecked((Exception)e);
        }
        try {
            this.csvBeanReader.close();
        }
        catch (IOException e) {
            logger.error("Error while closing csv bean reader {}", (Object)e.getMessage());
            DTThrowable.wrapIfChecked((Exception)e);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @VisibleForTesting
    public long getErrorTupleCount() {
        return this.errorTupleCount;
    }

    @VisibleForTesting
    public long getEmittedObjectCount() {
        return this.emittedObjectCount;
    }

    @VisibleForTesting
    public long getIncomingTuplesCount() {
        return this.incomingTuplesCount;
    }
}

