/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.parser;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedSchema {
    private static final String SEPARATOR = "separator";
    private static final String QUOTE_CHAR = "quoteChar";
    private static final String LINE_DELIMITER = "lineDelimiter";
    private static final String FIELDS = "fields";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String CONSTRAINTS = "constraints";
    public static final String REQUIRED = "required";
    public static final String EQUALS = "equals";
    public static final String LENGTH = "length";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MIN_VALUE = "minValue";
    public static final String MAX_VALUE = "maxValue";
    public static final String REGEX_PATTERN = "pattern";
    public static final String DATE_FORMAT = "format";
    public static final String LOCALE = "locale";
    public static final String TRUE_VALUE = "trueValue";
    public static final String FALSE_VALUE = "falseValue";
    private int delimiterChar = 44;
    private char quoteChar = (char)34;
    private String lineDelimiter = "\r\n";
    private List<String> fieldNames = new LinkedList<String>();
    private List<Field> fields = new LinkedList<Field>();
    private static final Logger logger = LoggerFactory.getLogger(DelimitedSchema.class);

    public DelimitedSchema(String json) {
        try {
            this.initialize(json);
        }
        catch (IOException | JSONException e) {
            logger.error("{}", e);
            throw new IllegalArgumentException(e);
        }
    }

    private void initialize(String json) throws JSONException, IOException {
        JSONObject jo = new JSONObject(json);
        if (jo.has(SEPARATOR)) {
            this.delimiterChar = jo.getString(SEPARATOR).charAt(0);
        }
        if (jo.has(QUOTE_CHAR)) {
            this.quoteChar = jo.getString(QUOTE_CHAR).charAt(0);
        }
        if (jo.has(LINE_DELIMITER)) {
            this.lineDelimiter = jo.getString(LINE_DELIMITER);
        }
        JSONArray fieldArray = jo.getJSONArray(FIELDS);
        for (int i = 0; i < fieldArray.length(); ++i) {
            JSONObject obj = fieldArray.getJSONObject(i);
            Field field = new Field(obj.getString(NAME), obj.getString(TYPE));
            this.fields.add(field);
            this.fieldNames.add(field.name);
            if (!obj.has(CONSTRAINTS)) continue;
            JSONObject constraints = obj.getJSONObject(CONSTRAINTS);
            field.constraints = (Map)new ObjectMapper().readValue(constraints.toString(), HashMap.class);
        }
    }

    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    public int getDelimiterChar() {
        return this.delimiterChar;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String toString() {
        return "DelimitedSchema [delimiterChar=" + this.delimiterChar + ", quoteChar=" + this.quoteChar + ", lineDelimiter=" + this.lineDelimiter + ", fieldNames=" + this.fieldNames + ", fields=" + this.fields + "]";
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public class Field {
        String name;
        FieldType type;
        Map<String, Object> constraints = new HashMap<String, Object>();

        public Field(String name, String type) {
            this.name = name;
            this.type = FieldType.valueOf(type.toUpperCase());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FieldType getType() {
            return this.type;
        }

        public void setType(FieldType type) {
            this.type = type;
        }

        public Map<String, Object> getConstraints() {
            return this.constraints;
        }

        public void setConstraints(Map<String, Object> constraints) {
            this.constraints = constraints;
        }

        public String toString() {
            return "Fields [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", constraints=" + this.constraints + "]";
        }
    }

    public static enum FieldType {
        BOOLEAN,
        DOUBLE,
        INTEGER,
        FLOAT,
        LONG,
        SHORT,
        CHARACTER,
        STRING,
        DATE;

    }
}

