/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.redis;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.redis.AbstractRedisInputOperator;
import com.datatorrent.contrib.redis.RedisStore;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.KeyValPair;
import com.datatorrent.lib.util.PojoUtils;
import com.datatorrent.netlet.util.DTThrowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public class RedisPOJOInputOperator
extends AbstractRedisInputOperator<KeyValPair<String, Object>> {
    protected final Map<String, Object> map = new HashMap<String, Object>();
    private ArrayList<FieldInfo> dataColumns;
    private transient ArrayList<Object> setters = new ArrayList();
    private boolean isFirstTuple = true;
    private String outputClass;
    private Class<?> objectClass;

    private Object convertMapToObject(Map<String, String> tuple) {
        try {
            Object mappedObject = this.objectClass.newInstance();
            block11: for (int i = 0; i < this.dataColumns.size(); ++i) {
                FieldInfo.SupportType type = this.dataColumns.get(i).getType();
                String columnName = this.dataColumns.get(i).getColumnName();
                if (i >= this.setters.size()) continue;
                String value = tuple.get(columnName);
                switch (type) {
                    case STRING: {
                        ((PojoUtils.Setter)this.setters.get(i)).set(mappedObject, (Object)value);
                        continue block11;
                    }
                    case BOOLEAN: {
                        ((PojoUtils.SetterBoolean)this.setters.get(i)).set(mappedObject, Boolean.parseBoolean(value));
                        continue block11;
                    }
                    case SHORT: {
                        ((PojoUtils.SetterShort)this.setters.get(i)).set(mappedObject, Short.parseShort(value));
                        continue block11;
                    }
                    case INTEGER: {
                        ((PojoUtils.SetterInt)this.setters.get(i)).set(mappedObject, Integer.parseInt(value));
                        continue block11;
                    }
                    case LONG: {
                        ((PojoUtils.SetterLong)this.setters.get(i)).set(mappedObject, Long.parseLong(value));
                        continue block11;
                    }
                    case FLOAT: {
                        ((PojoUtils.SetterFloat)this.setters.get(i)).set(mappedObject, Float.parseFloat(value));
                        continue block11;
                    }
                    case DOUBLE: {
                        ((PojoUtils.SetterDouble)this.setters.get(i)).set(mappedObject, Double.parseDouble(value));
                        continue block11;
                    }
                }
            }
            return mappedObject;
        }
        catch (Exception e) {
            DTThrowable.wrapIfChecked((Exception)e);
            return null;
        }
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
    }

    public void processFirstTuple(Map<String, String> value) throws ClassNotFoundException {
        this.objectClass = Class.forName(this.getOutputClass());
        int size = this.dataColumns.size();
        for (int i = 0; i < size; ++i) {
            PojoUtils.SetterBoolean setter;
            FieldInfo.SupportType type = this.dataColumns.get(i).getType();
            String getterExpression = this.dataColumns.get(i).getPojoFieldExpression();
            switch (type) {
                case STRING: {
                    setter = PojoUtils.createSetter(this.objectClass, (String)getterExpression, String.class);
                    break;
                }
                case BOOLEAN: {
                    setter = PojoUtils.createSetterBoolean(this.objectClass, (String)getterExpression);
                    break;
                }
                case SHORT: {
                    setter = PojoUtils.createSetterShort(this.objectClass, (String)getterExpression);
                    break;
                }
                case INTEGER: {
                    setter = PojoUtils.createSetterInt(this.objectClass, (String)getterExpression);
                    break;
                }
                case LONG: {
                    setter = PojoUtils.createSetterLong(this.objectClass, (String)getterExpression);
                    break;
                }
                case FLOAT: {
                    setter = PojoUtils.createSetterFloat(this.objectClass, (String)getterExpression);
                    break;
                }
                case DOUBLE: {
                    setter = PojoUtils.createSetterDouble(this.objectClass, (String)getterExpression);
                    break;
                }
                default: {
                    setter = PojoUtils.createSetter(this.objectClass, (String)getterExpression, Object.class);
                }
            }
            this.setters.add(setter);
        }
    }

    @Override
    public void processTuples() {
        for (String key : this.keys) {
            if (!((RedisStore)this.store).getType(key).equals("hash")) continue;
            Map<String, String> mapValue = ((RedisStore)this.store).getMap(key);
            if (this.isFirstTuple) {
                try {
                    this.processFirstTuple(mapValue);
                }
                catch (ClassNotFoundException e) {
                    DTThrowable.rethrow((Exception)e);
                }
            }
            this.isFirstTuple = false;
            this.outputPort.emit((Object)new KeyValPair((Object)key, this.convertMapToObject(mapValue)));
        }
        this.keys.clear();
    }

    public String getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    public ArrayList<FieldInfo> getDataColumns() {
        return this.dataColumns;
    }

    public void setDataColumns(ArrayList<FieldInfo> dataColumns) {
        this.dataColumns = dataColumns;
    }

    public KeyValPair<String, Object> convertToTuple(Map<Object, Object> o) {
        return null;
    }
}

