/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.solr;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.solr.SolrServerConnector;
import com.datatorrent.lib.db.AbstractStoreInputOperator;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolrInputOperator<T, S extends SolrServerConnector>
extends AbstractStoreInputOperator<T, S> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSolrInputOperator.class);
    @NotNull
    protected S solrServerConnector;
    private SolrDocument lastEmittedTuple;
    private long lastEmittedTimeStamp;

    public void beginWindow(long windowId) {
    }

    public void endWindow() {
    }

    public void setup(Context.OperatorContext context) {
        try {
            this.solrServerConnector.connect();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to connect to Solr Server", ex);
        }
    }

    public void teardown() {
        ((SolrServerConnector)this.solrServerConnector).getSolrServer().shutdown();
    }

    public long getLastEmittedTimeStamp() {
        return this.lastEmittedTimeStamp;
    }

    public SolrDocument getLastEmittedTuple() {
        return this.lastEmittedTuple;
    }

    public SolrServer getSolrServer() {
        return ((SolrServerConnector)this.solrServerConnector).getSolrServer();
    }

    public SolrServerConnector getSolrServerConnector() {
        return this.solrServerConnector;
    }

    public void setSolrServerConnector(S solrServerConnector) {
        this.solrServerConnector = solrServerConnector;
    }

    public void emitTuples() {
        SolrParams solrQueryParams = this.getQueryParams();
        try {
            SolrServer solrServer = ((SolrServerConnector)this.solrServerConnector).getSolrServer();
            QueryResponse response = solrServer.query(solrQueryParams);
            SolrDocumentList queriedDocuments = response.getResults();
            for (SolrDocument solrDocument : queriedDocuments) {
                this.emitTuple(solrDocument);
                this.lastEmittedTuple = solrDocument;
                this.lastEmittedTimeStamp = System.currentTimeMillis();
                logger.debug("Emiting document: " + solrDocument.getFieldValue("name"));
            }
        }
        catch (SolrServerException ex) {
            throw new RuntimeException("Unable to fetch documents from Solr server", ex);
        }
    }

    protected abstract void emitTuple(SolrDocument var1);

    public abstract SolrParams getQueryParams();
}

