/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.solr;

import com.datatorrent.contrib.solr.AbstractSolrInputOperator;
import com.datatorrent.contrib.solr.SolrServerConnector;
import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.servlet.SolrRequestParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrInputOperator
extends AbstractSolrInputOperator<Map<String, Object>, SolrServerConnector> {
    private static final Logger logger = LoggerFactory.getLogger(SolrInputOperator.class);
    private String solrQuery;

    @Override
    protected void emitTuple(SolrDocument document) {
        this.outputPort.emit((Object)document.getFieldValueMap());
    }

    @Override
    public SolrParams getQueryParams() {
        MultiMapSolrParams solrParams;
        if (this.solrQuery != null) {
            solrParams = SolrRequestParsers.parseQueryString((String)this.solrQuery);
        } else {
            logger.debug("Solr document fetch query is not set, using wild card query for search.");
            solrParams = SolrRequestParsers.parseQueryString((String)"*");
        }
        return solrParams;
    }

    public String getSolrQuery() {
        return this.solrQuery;
    }

    public void setSolrQuery(String solrQuery) {
        this.solrQuery = solrQuery;
    }
}

