/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.splunk;

import com.datatorrent.api.Context;
import com.datatorrent.contrib.splunk.SplunkStore;
import com.datatorrent.lib.db.AbstractStoreOutputOperator;
import com.splunk.TcpInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class SplunkTcpOutputOperator<T>
extends AbstractStoreOutputOperator<T, SplunkStore> {
    private String tcpPort;
    private transient Socket socket;
    private transient TcpInput tcpInput;
    private transient DataOutputStream stream;

    public String getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(String tcpPort) {
        this.tcpPort = tcpPort;
    }

    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.tcpInput = (TcpInput)((SplunkStore)this.store).getService().getInputs().get((Object)this.tcpPort);
        try {
            this.socket = this.tcpInput.attach();
            this.stream = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processTuple(T tuple) {
        try {
            this.stream.writeBytes(tuple.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void endWindow() {
        try {
            this.stream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void teardown() {
        super.teardown();
        try {
            this.stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

