/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.contrib.sqlite;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import com.datatorrent.api.Context;
import com.datatorrent.lib.streamquery.AbstractSqlStreamOperator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqliteStreamOperator
extends AbstractSqlStreamOperator {
    private static final Logger logger = LoggerFactory.getLogger(SqliteStreamOperator.class);
    protected transient ArrayList<SQLiteStatement> insertStatements = new ArrayList(5);
    protected transient SQLiteStatement beginStatement;
    protected transient SQLiteStatement commitStatement;
    protected transient SQLiteStatement execStatement;
    protected transient ArrayList<SQLiteStatement> deleteStatements = new ArrayList(5);
    protected transient SQLiteConnection db;

    public void setup(Context.OperatorContext context) {
        this.db = new SQLiteConnection(new File("/tmp/sqlite.db"));
        java.util.logging.Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.SEVERE);
        try {
            this.db.open(true);
            for (int i = 0; i < this.inputSchemas.size(); ++i) {
                AbstractSqlStreamOperator.InputSchema inputSchema = (AbstractSqlStreamOperator.InputSchema)this.inputSchemas.get(i);
                ArrayList indexes = new ArrayList();
                if (inputSchema == null || inputSchema.columnInfoMap.isEmpty()) continue;
                String columnSpec = "";
                String columnNames = "";
                String insertQuestionMarks = "";
                int j = 0;
                for (Map.Entry entry : inputSchema.columnInfoMap.entrySet()) {
                    if (!columnSpec.isEmpty()) {
                        columnSpec = columnSpec + ",";
                        columnNames = columnNames + ",";
                        insertQuestionMarks = insertQuestionMarks + ",";
                    }
                    columnSpec = columnSpec + (String)entry.getKey();
                    columnSpec = columnSpec + " ";
                    columnSpec = columnSpec + ((AbstractSqlStreamOperator.InputSchema.ColumnInfo)entry.getValue()).type;
                    if (((AbstractSqlStreamOperator.InputSchema.ColumnInfo)entry.getValue()).isColumnIndex) {
                        indexes.add(entry.getKey());
                    }
                    columnNames = columnNames + (String)entry.getKey();
                    insertQuestionMarks = insertQuestionMarks + "?";
                    ((AbstractSqlStreamOperator.InputSchema.ColumnInfo)entry.getValue()).bindIndex = ++j;
                }
                String createTempTableStmt = "CREATE TEMP TABLE " + inputSchema.name + "(" + columnSpec + ")";
                SQLiteStatement st = this.db.prepare(createTempTableStmt);
                st.step();
                st.dispose();
                for (String index : indexes) {
                    String createIndexStmt = "CREATE INDEX " + inputSchema.name + "_" + index + "_idx ON " + inputSchema.name + " (" + index + ")";
                    st = this.db.prepare(createIndexStmt);
                    st.step();
                    st.dispose();
                }
                String insertStmt = "INSERT INTO " + inputSchema.name + " (" + columnNames + ") VALUES (" + insertQuestionMarks + ")";
                this.insertStatements.add(i, this.db.prepare(insertStmt));
                this.deleteStatements.add(i, this.db.prepare("DELETE FROM " + inputSchema.name));
            }
            this.beginStatement = this.db.prepare("BEGIN");
            this.commitStatement = this.db.prepare("COMMIT");
            this.execStatement = this.db.prepare(this.statement);
        }
        catch (SQLiteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void beginWindow(long windowId) {
        try {
            this.beginStatement.step();
            this.beginStatement.reset();
        }
        catch (SQLiteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void processTuple(int tableNum, HashMap<String, Object> tuple) {
        AbstractSqlStreamOperator.InputSchema inputSchema = (AbstractSqlStreamOperator.InputSchema)this.inputSchemas.get(tableNum);
        SQLiteStatement insertStatement = this.insertStatements.get(tableNum);
        try {
            for (Map.Entry<String, Object> entry : tuple.entrySet()) {
                AbstractSqlStreamOperator.InputSchema.ColumnInfo t = (AbstractSqlStreamOperator.InputSchema.ColumnInfo)inputSchema.columnInfoMap.get(entry.getKey());
                if (t == null || t.bindIndex == 0) continue;
                insertStatement.bind(t.bindIndex, entry.getValue().toString());
            }
            insertStatement.step();
            insertStatement.reset();
        }
        catch (SQLiteException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void endWindow() {
        try {
            this.commitStatement.step();
            this.commitStatement.reset();
            if (this.bindings != null) {
                for (int i = 0; i < this.bindings.size(); ++i) {
                    this.execStatement.bind(i, this.bindings.get(i).toString());
                }
            }
            int columnCount = this.execStatement.columnCount();
            while (this.execStatement.step()) {
                HashMap<String, Object> resultRow = new HashMap<String, Object>();
                for (int i = 0; i < columnCount; ++i) {
                    resultRow.put(this.execStatement.getColumnName(i), this.execStatement.columnValue(i));
                }
                this.result.emit(resultRow);
            }
            this.execStatement.reset();
            for (SQLiteStatement st : this.deleteStatements) {
                st.step();
                st.reset();
            }
        }
        catch (SQLiteException ex) {
            throw new RuntimeException(ex);
        }
        this.bindings = null;
    }

    public void teardown() {
        this.db.dispose();
    }
}

