/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.contrib.parser;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.lib.parser.Parser;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.KeyValPair;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.apex.malhar.contrib.parser.JsonKeyFinder;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.elasticsearch.common.primitives.Ints;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class StreamingJsonParser
extends Parser<byte[], KeyValPair<String, String>> {
    private transient JSONParser jsonParser;
    private transient String fieldMappingString;
    private transient List<FieldInfo> fieldInfos;
    private transient List<ActiveFieldInfo> columnFieldSetters;
    protected JsonKeyFinder finder;
    private static final String FIELD_SEPARATOR = ":";
    private static final String RECORD_SEPARATOR = ",";
    private transient ArrayList<String> columnFields;
    private transient Class<?> pojoClass;
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> output = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            StreamingJsonParser.this.jsonParser = new JSONParser();
            StreamingJsonParser.this.finder = new JsonKeyFinder();
            StreamingJsonParser.this.columnFields = new ArrayList();
            StreamingJsonParser.this.columnFieldSetters = Lists.newArrayList();
            StreamingJsonParser.this.setPojoClass((Class)context.getValue(Context.PortContext.TUPLE_CLASS));
            if (StreamingJsonParser.this.getFieldMappingString() == null) {
                StreamingJsonParser.this.setFieldInfos(StreamingJsonParser.this.createFieldInfoMap(StreamingJsonParser.this.generateFieldInfoInputs(StreamingJsonParser.this.getPojoClass())));
            } else {
                StreamingJsonParser.this.setFieldInfos(StreamingJsonParser.this.createFieldInfoMap(StreamingJsonParser.this.getFieldMappingString()));
            }
            StreamingJsonParser.this.initColumnFieldSetters(StreamingJsonParser.this.getFieldInfos());
            StreamingJsonParser.this.initializeActiveFieldSetters();
            ListIterator itr = StreamingJsonParser.this.fieldInfos.listIterator();
            while (itr.hasNext()) {
                StreamingJsonParser.this.columnFields.add(((FieldInfo)itr.next()).getColumnName());
            }
            StreamingJsonParser.this.finder.setMatchKeyList(StreamingJsonParser.this.columnFields);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(StreamingJsonParser.class);

    private Class<?> getPojoClass() {
        return this.pojoClass;
    }

    public void setPojoClass(Class<?> pojoClass) {
        this.pojoClass = pojoClass;
    }

    public String getFieldMappingString() {
        return this.fieldMappingString;
    }

    public void setFieldMappingString(String pojoFieldsToJsonMapping) {
        this.fieldMappingString = pojoFieldsToJsonMapping;
    }

    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
    }

    public void processTuple(byte[] tuple) {
        ++this.incomingTuplesCount;
        Object obj = this.convert(tuple);
        if (obj != null) {
            this.output.emit(obj);
            ++this.emittedObjectCount;
        }
    }

    public Object convert(byte[] tuple) {
        String str;
        if (tuple == null) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair(null, (Object)"null tuple"));
            }
            ++this.errorTupleCount;
            return null;
        }
        try {
            str = new String(tuple, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)tuple.toString(), (Object)"Encoding not supported"));
            }
            ++this.errorTupleCount;
            LOG.error("Encoding not supported", (Throwable)e1);
            throw new RuntimeException(e1);
        }
        try {
            this.finder.setKeyCount(0);
            this.finder.getKeyValMap().clear();
            while (!this.finder.isEnd()) {
                this.jsonParser.parse(str, (ContentHandler)this.finder, true);
                if (this.finder.getKeyCount() != this.columnFields.size()) continue;
            }
            this.jsonParser.reset();
            return this.setPojoFields(this.finder.getKeyValMap());
        }
        catch (IllegalAccessException | InstantiationException | ParseException e) {
            if (this.err.isConnected()) {
                this.err.emit((Object)new KeyValPair((Object)str, (Object)e.getMessage()));
            }
            ++this.errorTupleCount;
            LOG.error("Exception in parsing the record", e);
            throw new RuntimeException(e);
        }
    }

    private List<FieldInfo> createFieldInfoMap(String str) {
        this.fieldInfos = new ArrayList<FieldInfo>();
        StringTokenizer strtok = new StringTokenizer(str, RECORD_SEPARATOR);
        while (strtok.hasMoreTokens()) {
            String[] token = strtok.nextToken().split(FIELD_SEPARATOR);
            try {
                this.fieldInfos.add(new FieldInfo(token[0], token[1], FieldInfo.SupportType.valueOf((String)token[2])));
            }
            catch (Exception e) {
                LOG.error("Invalid support type", (Throwable)e);
            }
        }
        return this.fieldInfos;
    }

    public KeyValPair<String, String> processErrorTuple(byte[] input) {
        throw new UnsupportedOperationException("Not supported");
    }

    private List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    private void setFieldInfos(List<FieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    private String generateFieldInfoInputs(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Class c = ClassUtils.primitiveToWrapper(f.getType());
            sb.append(f.getName()).append(FIELD_SEPARATOR).append(f.getName()).append(FIELD_SEPARATOR).append(c.getSimpleName().toUpperCase()).append(RECORD_SEPARATOR);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void initColumnFieldSetters(List<FieldInfo> fieldInfos) {
        for (FieldInfo fi : fieldInfos) {
            if (this.columnFieldSetters == null) {
                this.columnFieldSetters = Lists.newArrayList();
            }
            this.columnFieldSetters.add(new ActiveFieldInfo(fi));
        }
    }

    private void initializeActiveFieldSetters() {
        for (int i = 0; i < this.columnFieldSetters.size(); ++i) {
            ActiveFieldInfo activeFieldInfo = this.columnFieldSetters.get(i);
            FieldInfo.SupportType st = activeFieldInfo.fieldInfo.getType();
            switch (st) {
                case BOOLEAN: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterBoolean(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case DOUBLE: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterDouble(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case FLOAT: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterFloat(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case INTEGER: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterInt(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                case STRING: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetter(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression(), (Class)activeFieldInfo.fieldInfo.getType().getJavaType());
                    break;
                }
                case LONG: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterLong(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    break;
                }
                default: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetter(this.getPojoClass(), (String)activeFieldInfo.fieldInfo.getPojoFieldExpression(), Byte.class);
                }
            }
            this.columnFieldSetters.get((int)i).setterOrGetter = activeFieldInfo.setterOrGetter;
        }
    }

    private Object setPojoFields(HashMap<Object, Object> tuple) throws InstantiationException, IllegalAccessException {
        Object newObj = this.getPojoClass().newInstance();
        try {
            for (int i = 0; i < this.columnFieldSetters.size(); ++i) {
                ActiveFieldInfo afi = this.columnFieldSetters.get(i);
                FieldInfo.SupportType st = afi.fieldInfo.getType();
                Object val = null;
                try {
                    val = tuple.get(afi.fieldInfo.getColumnName());
                }
                catch (Exception e) {
                    LOG.error("Could not find field -" + afi.fieldInfo.getColumnName() + "- in the generic record", (Throwable)e);
                    val = null;
                }
                if (val == null) continue;
                try {
                    switch (st) {
                        case BOOLEAN: {
                            ((PojoUtils.SetterBoolean)afi.setterOrGetter).set(newObj, ((Boolean)tuple.get(afi.fieldInfo.getColumnName())).booleanValue());
                            break;
                        }
                        case DOUBLE: {
                            ((PojoUtils.SetterDouble)afi.setterOrGetter).set(newObj, ((Double)tuple.get(afi.fieldInfo.getColumnName())).doubleValue());
                            break;
                        }
                        case INTEGER: {
                            int intVal = Ints.checkedCast((long)((Long)tuple.get(afi.fieldInfo.getColumnName())));
                            ((PojoUtils.SetterInt)afi.setterOrGetter).set(newObj, intVal);
                            break;
                        }
                        case STRING: {
                            ((PojoUtils.Setter)afi.setterOrGetter).set(newObj, (Object)new String(tuple.get(afi.fieldInfo.getColumnName()).toString()));
                            break;
                        }
                        case LONG: {
                            ((PojoUtils.SetterLong)afi.setterOrGetter).set(newObj, ((Long)tuple.get(afi.fieldInfo.getColumnName())).longValue());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid Support Type");
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Exception in setting value", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Generic Exception in setting value" + ex.getMessage());
            newObj = null;
        }
        return newObj;
    }

    protected static class ActiveFieldInfo {
        final FieldInfo fieldInfo;
        Object setterOrGetter;

        ActiveFieldInfo(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
        }
    }
}

