/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kafka;

import com.datatorrent.api.Context;
import com.datatorrent.api.Operator;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

@InterfaceStability.Evolving
public abstract class AbstractKafkaOutputOperator<K, V>
implements Operator {
    private transient Producer<K, V> producer;
    @NotNull
    private String topic;
    private Properties properties = new Properties();

    public void setup(Context.OperatorContext context) {
        this.producer = new KafkaProducer(this.properties);
    }

    public void teardown() {
        this.producer.close();
    }

    public void beginWindow(long windowId) {
    }

    public void endWindow() {
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void setProperty(Object key, Object val) {
        this.properties.put(key, val);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    protected Producer<K, V> getProducer() {
        return this.producer;
    }
}

