/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kafka;

import com.datatorrent.api.AutoMetric;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

@InterfaceStability.Evolving
public class KafkaMetrics
implements Serializable {
    private KafkaConsumerStats[] stats;
    private transient long lastMetricSampleTime = 0L;
    private transient long metricsRefreshInterval;

    public KafkaMetrics(long metricsRefreshInterval) {
        this.metricsRefreshInterval = metricsRefreshInterval;
    }

    void updateMetrics(String[] clusters, Map<String, Map<MetricName, ? extends Metric>> metricsMap) {
        long current = System.currentTimeMillis();
        if (current - this.lastMetricSampleTime < this.metricsRefreshInterval) {
            return;
        }
        this.lastMetricSampleTime = current;
        if (this.stats == null) {
            this.stats = new KafkaConsumerStats[clusters.length];
        }
        for (int i = 0; i < clusters.length; ++i) {
            Map<MetricName, ? extends Metric> cMetrics;
            if (this.stats[i] == null) {
                this.stats[i] = new KafkaConsumerStats();
                this.stats[i].cluster = clusters[i];
            }
            if ((cMetrics = metricsMap.get(clusters[i])) == null || cMetrics.isEmpty()) {
                this.stats[i].bytesPerSec = 0.0;
                this.stats[i].msgsPerSec = 0.0;
                continue;
            }
            if (this.stats[i].bytePerSecMK == null || this.stats[i].msgPerSecMK == null) {
                for (MetricName mn : cMetrics.keySet()) {
                    if (mn.name().equals("bytes-consumed-rate")) {
                        this.stats[i].bytePerSecMK = mn;
                        continue;
                    }
                    if (!mn.name().equals("records-consumed-rate")) continue;
                    this.stats[i].msgPerSecMK = mn;
                }
            }
            this.stats[i].bytesPerSec = cMetrics.get(this.stats[i].bytePerSecMK).value();
            this.stats[i].msgsPerSec = cMetrics.get(this.stats[i].msgPerSecMK).value();
        }
    }

    public KafkaConsumerStats[] getStats() {
        return this.stats;
    }

    public static class KafkaMetricsAggregator
    implements AutoMetric.Aggregator,
    Serializable {
        public Map<String, Object> aggregate(long l, Collection<AutoMetric.PhysicalMetricsContext> collection) {
            double totalBytesPerSec = 0.0;
            double totalMsgsPerSec = 0.0;
            HashMap<String, Object> total = new HashMap<String, Object>();
            for (AutoMetric.PhysicalMetricsContext pmc : collection) {
                KafkaMetrics km = (KafkaMetrics)pmc.getMetrics().get("metrics");
                for (KafkaConsumerStats kcs : km.stats) {
                    totalBytesPerSec += kcs.bytesPerSec;
                    totalMsgsPerSec += kcs.msgsPerSec;
                }
            }
            total.put("totalBytesPerSec", totalBytesPerSec);
            total.put("totalMsgPerSec", totalMsgsPerSec);
            return total;
        }
    }

    public static class KafkaConsumerStats
    implements Serializable {
        private static final long serialVersionUID = -2867402654990209006L;
        public transient MetricName msgPerSecMK;
        public transient MetricName bytePerSecMK;
        public String cluster;
        public double msgsPerSec;
        public double bytesPerSec;
    }
}

