/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kafka;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.apex.malhar.kafka.AbstractKafkaConsumer;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;

@InterfaceStability.Evolving
public class KafkaConsumer09
implements AbstractKafkaConsumer {
    private KafkaConsumer<byte[], byte[]> consumer;

    public KafkaConsumer09(Properties properties) {
        this.consumer = new KafkaConsumer(properties);
    }

    public boolean isConsumerContainsPartition(TopicPartition topicPartition) {
        return this.consumer.assignment().contains(topicPartition);
    }

    public void seekToOffset(TopicPartition topicPartition, long offset) {
        this.consumer.seek(topicPartition, offset);
    }

    public ConsumerRecords<byte[], byte[]> pollRecords(long timeOut) {
        return this.consumer.poll(timeOut);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.consumer.commitAsync(offsets, callback);
    }

    public void assignPartitions(List<TopicPartition> partitions) {
        this.consumer.assign(partitions);
    }

    public void seekToBeginning(TopicPartition ... partitions) {
        this.consumer.seekToBeginning(partitions);
    }

    public void seekToEnd(TopicPartition ... partitions) {
        this.consumer.seekToEnd(partitions);
    }

    public void wakeup() {
        this.consumer.wakeup();
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.consumer.metrics();
    }

    public void close() {
        this.consumer.close();
    }

    public void resumeAllPartitions() {
        this.consumer.resume((TopicPartition[])Iterables.toArray(this.getPartitions(), TopicPartition.class));
    }

    public Collection<TopicPartition> getPartitions() {
        return this.consumer.assignment();
    }

    public void resumePartition(TopicPartition tp) {
        this.consumer.resume(new TopicPartition[]{tp});
    }

    public void pausePartition(TopicPartition tp) {
        this.consumer.pause(new TopicPartition[]{tp});
    }

    public long positionPartition(TopicPartition tp) {
        return this.consumer.position(tp);
    }
}

