/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasBaseClient;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.SortOrder;
import org.apache.atlas.bulkimport.BulkImportResponse;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.model.audit.AuditSearchParameters;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.discovery.AtlasQuickSearchResult;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.AtlasSuggestionsResult;
import org.apache.atlas.model.discovery.QuickSearchParameters;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasEntityHeaders;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.ClassificationAssociateRequest;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypeDefHeader;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class AtlasClientV2
extends AtlasBaseClient {
    public static final String TYPES_API = "api/atlas/v2/types/";
    public static final String ENTITY_API = "api/atlas/v2/entity/";
    private static final String PREFIX_ATTR = "attr:";
    private static final String PREFIX_ATTR_ = "attr_";
    private static final String TYPEDEFS_API = "api/atlas/v2/types/typedefs/";
    private static final String TYPEDEF_BY_NAME = "api/atlas/v2/types/typedef/name/";
    private static final String TYPEDEF_BY_GUID = "api/atlas/v2/types/typedef/guid/";
    private static final String GET_BY_NAME_TEMPLATE = "api/atlas/v2/types/%s/name/%s";
    private static final String GET_BY_GUID_TEMPLATE = "api/atlas/v2/types/%s/guid/%s";
    private static final String ENTITY_BULK_API = "api/atlas/v2/entity/bulk/";
    private static final String ADMIN_API = "api/atlas/admin/";
    private static final String ENTITY_PURGE_API = "api/atlas/admin/purge/";
    private static final String ATLAS_AUDIT_API = "api/atlas/admin/audits/";
    private static final String LINEAGE_URI = "api/atlas/v2/lineage/";
    private static final String DISCOVERY_URI = "api/atlas/v2/search";
    private static final String DSL_SEARCH_URI = "api/atlas/v2/search/dsl";
    private static final String FULL_TEXT_SEARCH_URI = "api/atlas/v2/search/fulltext";
    private static final String BASIC_SEARCH_URI = "api/atlas/v2/search/basic";
    private static final String FACETED_SEARCH_URI = "api/atlas/v2/search/basic";
    private static final String SAVED_SEARCH_URI = "api/atlas/v2/search/saved";
    private static final String QUICK_SEARCH_URI = "api/atlas/v2/search/quick";
    private static final String RELATIONSHIPS_URI = "api/atlas/v2/relationship/";
    private static final String BULK_HEADERS = "bulk/headers";
    private static final String BULK_SET_CLASSIFICATIONS = "bulk/setClassifications";
    private static final String RELATIONSHIP_URI = "api/atlas/v2/search/relationship";
    private static final String GLOSSARY_URI = "api/atlas/v2/glossary";
    private static final String GLOSSARY_TERM = "api/atlas/v2/glossary/term";
    private static final String GLOSSARY_TERMS = "api/atlas/v2/glossary/terms";
    private static final String GLOSSARY_CATEGORY = "api/atlas/v2/glossary/category";
    private static final String GLOSSARY_CATEGORIES = "api/atlas/v2/glossary/categories";

    public AtlasClientV2(String[] baseUrl, String[] basicAuthUserNamePassword) {
        super(baseUrl, basicAuthUserNamePassword);
    }

    public AtlasClientV2(String ... baseUrls) throws AtlasException {
        super(baseUrls);
    }

    public AtlasClientV2(UserGroupInformation ugi, String doAsUser, String ... baseUrls) {
        super(ugi, doAsUser, baseUrls);
    }

    public AtlasClientV2(String[] baseUrl, String cookieName, String value, String path, String domain) {
        super(baseUrl, new Cookie(cookieName, value, path, domain));
    }

    public AtlasClientV2(String[] baseUrl, Cookie cookie) {
        super(baseUrl, cookie);
    }

    public AtlasClientV2(Configuration configuration, String[] baseUrl, String[] basicAuthUserNamePassword) {
        super(configuration, baseUrl, basicAuthUserNamePassword);
    }

    @VisibleForTesting
    AtlasClientV2(WebResource service, Configuration configuration) {
        super(service, configuration);
    }

    public AtlasTypesDef getAllTypeDefs(SearchFilter searchFilter) throws AtlasServiceException {
        return (AtlasTypesDef)this.callAPI(API_V2.GET_ALL_TYPE_DEFS, AtlasTypesDef.class, searchFilter.getParams());
    }

    public List<AtlasTypeDefHeader> getAllTypeDefHeaders(SearchFilter searchFilter) throws AtlasServiceException {
        return (List)this.callAPI(API_V2.GET_ALL_TYPE_DEF_HEADERS, List.class, searchFilter.getParams());
    }

    public boolean typeWithGuidExists(String guid) {
        try {
            this.callAPI(API_V2.GET_TYPEDEF_BY_GUID, String.class, null, new String[]{guid});
        }
        catch (AtlasServiceException e) {
            return false;
        }
        return true;
    }

    public boolean typeWithNameExists(String name) {
        try {
            this.callAPI(API_V2.GET_TYPEDEF_BY_NAME, String.class, null, new String[]{name});
        }
        catch (AtlasServiceException e) {
            return false;
        }
        return true;
    }

    public AtlasEnumDef getEnumDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasEnumDef.class);
    }

    public AtlasEnumDef getEnumDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasEnumDef.class);
    }

    public AtlasStructDef getStructDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasStructDef.class);
    }

    public AtlasStructDef getStructDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasStructDef.class);
    }

    public AtlasClassificationDef getClassificationDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasClassificationDef.class);
    }

    public AtlasClassificationDef getClassificationDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasClassificationDef.class);
    }

    public AtlasEntityDef getEntityDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasEntityDef.class);
    }

    public AtlasEntityDef getEntityDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasEntityDef.class);
    }

    public AtlasRelationshipDef getRelationshipDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasRelationshipDef.class);
    }

    public AtlasRelationshipDef getRelationshipDefByGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasRelationshipDef.class);
    }

    public AtlasBusinessMetadataDef getBusinessMetadataDefByName(String name) throws AtlasServiceException {
        return this.getTypeDefByName(name, AtlasBusinessMetadataDef.class);
    }

    public AtlasBusinessMetadataDef getBusinessMetadataDefGuid(String guid) throws AtlasServiceException {
        return this.getTypeDefByGuid(guid, AtlasBusinessMetadataDef.class);
    }

    @Deprecated
    public AtlasEnumDef createEnumDef(AtlasEnumDef enumDef) throws AtlasServiceException {
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getEnumDefs().add(enumDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(typesDef);
        assert (created != null);
        assert (created.getEnumDefs() != null);
        return (AtlasEnumDef)created.getEnumDefs().get(0);
    }

    @Deprecated
    public AtlasStructDef createStructDef(AtlasStructDef structDef) throws AtlasServiceException {
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getStructDefs().add(structDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(typesDef);
        assert (created != null);
        assert (created.getStructDefs() != null);
        return (AtlasStructDef)created.getStructDefs().get(0);
    }

    @Deprecated
    public AtlasEntityDef createEntityDef(AtlasEntityDef entityDef) throws AtlasServiceException {
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getEntityDefs().add(entityDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(typesDef);
        assert (created != null);
        assert (created.getEntityDefs() != null);
        return (AtlasEntityDef)created.getEntityDefs().get(0);
    }

    @Deprecated
    public AtlasClassificationDef createClassificationDef(AtlasClassificationDef classificationDef) throws AtlasServiceException {
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getClassificationDefs().add(classificationDef);
        AtlasTypesDef created = this.createAtlasTypeDefs(typesDef);
        assert (created != null);
        assert (created.getClassificationDefs() != null);
        return (AtlasClassificationDef)created.getClassificationDefs().get(0);
    }

    public AtlasTypesDef createAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasServiceException {
        return (AtlasTypesDef)this.callAPI(API_V2.CREATE_TYPE_DEFS, AtlasTypesDef.class, AtlasType.toJson((Object)typesDef), new String[0]);
    }

    public AtlasTypesDef updateAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasServiceException {
        return (AtlasTypesDef)this.callAPI(API_V2.UPDATE_TYPE_DEFS, AtlasTypesDef.class, AtlasType.toJson((Object)typesDef), new String[0]);
    }

    public void deleteAtlasTypeDefs(AtlasTypesDef typesDef) throws AtlasServiceException {
        this.callAPI(API_V2.DELETE_TYPE_DEFS, null, AtlasType.toJson((Object)typesDef), new String[0]);
    }

    public void deleteTypeByName(String typeName) throws AtlasServiceException {
        this.callAPI(API_V2.DELETE_TYPE_DEF_BY_NAME, null, null, new String[]{typeName});
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByGuid(String guid) throws AtlasServiceException {
        return this.getEntityByGuid(guid, false, false);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByGuid(String guid, boolean minExtInfo, boolean ignoreRelationships) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"minExtInfo", (Object)String.valueOf(minExtInfo));
        queryParams.add((Object)"ignoreRelationships", (Object)String.valueOf(ignoreRelationships));
        return (AtlasEntity.AtlasEntityWithExtInfo)this.callAPI(API_V2.GET_ENTITY_BY_GUID, AtlasEntity.AtlasEntityWithExtInfo.class, (MultivaluedMap)queryParams, new String[]{guid});
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByAttribute(String typeName, Map<String, String> uniqAttributes) throws AtlasServiceException {
        return this.getEntityByAttribute(typeName, uniqAttributes, false, false);
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityByAttribute(String typeName, Map<String, String> uniqAttributes, boolean minExtInfo, boolean ignoreRelationship) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        queryParams.add((Object)"minExtInfo", (Object)String.valueOf(minExtInfo));
        queryParams.add((Object)"ignoreRelationships", (Object)String.valueOf(ignoreRelationship));
        return (AtlasEntity.AtlasEntityWithExtInfo)this.callAPI(API_V2.GET_ENTITY_BY_UNIQUE_ATTRIBUTE, AtlasEntity.AtlasEntityWithExtInfo.class, queryParams, new String[]{typeName});
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByGuids(List<String> guids) throws AtlasServiceException {
        return this.getEntitiesByGuids(guids, false, false);
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByGuids(List<String> guids, boolean minExtInfo, boolean ignoreRelationships) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.put((Object)"guid", guids);
        queryParams.add((Object)"minExtInfo", (Object)String.valueOf(minExtInfo));
        queryParams.add((Object)"ignoreRelationships", (Object)String.valueOf(ignoreRelationships));
        return (AtlasEntity.AtlasEntitiesWithExtInfo)this.callAPI(API_V2.GET_ENTITIES_BY_GUIDS, AtlasEntity.AtlasEntitiesWithExtInfo.class, (MultivaluedMap)queryParams);
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByAttribute(String typeName, List<Map<String, String>> uniqAttributesList) throws AtlasServiceException {
        return this.getEntitiesByAttribute(typeName, uniqAttributesList, false, false);
    }

    public AtlasEntity.AtlasEntitiesWithExtInfo getEntitiesByAttribute(String typeName, List<Map<String, String>> uniqAttributesList, boolean minExtInfo, boolean ignoreRelationship) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributesList, null);
        queryParams.add((Object)"minExtInfo", (Object)String.valueOf(minExtInfo));
        queryParams.add((Object)"ignoreRelationships", (Object)String.valueOf(ignoreRelationship));
        return (AtlasEntity.AtlasEntitiesWithExtInfo)this.callAPI(API_V2.GET_ENTITIES_BY_UNIQUE_ATTRIBUTE, AtlasEntity.AtlasEntitiesWithExtInfo.class, queryParams, new String[]{typeName});
    }

    public AtlasEntityHeader getEntityHeaderByGuid(String entityGuid) throws AtlasServiceException {
        return (AtlasEntityHeader)this.callAPI(this.formatPathParameters(API_V2.GET_ENTITY_HEADER_BY_GUID, entityGuid), AtlasEntityHeader.class, null);
    }

    public AtlasEntityHeader getEntityHeaderByAttribute(String typeName, Map<String, String> uniqAttributes) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        return (AtlasEntityHeader)this.callAPI(this.formatPathParameters(API_V2.GET_ENTITY_HEADER_BY_UNIQUE_ATTRIBUTE, typeName), AtlasEntityHeader.class, queryParams);
    }

    public List<EntityAuditEventV2> getAuditEvents(String guid, String startKey, EntityAuditEventV2.EntityAuditActionV2 auditAction, short count) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"startKey", (Object)startKey);
        if (auditAction != null) {
            queryParams.add((Object)"auditAction", (Object)auditAction.toString());
        }
        queryParams.add((Object)"count", (Object)String.valueOf(count));
        return (List)this.callAPI(this.formatPathParameters(API_V2.GET_AUDIT_EVENTS, guid), List.class, (MultivaluedMap)queryParams);
    }

    public EntityMutationResponse createEntity(AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.CREATE_ENTITY, EntityMutationResponse.class, entity, new String[0]);
    }

    public EntityMutationResponse createEntities(AtlasEntity.AtlasEntitiesWithExtInfo atlasEntities) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.CREATE_ENTITIES, EntityMutationResponse.class, atlasEntities, new String[0]);
    }

    public EntityMutationResponse updateEntity(AtlasEntity.AtlasEntityWithExtInfo entity) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.UPDATE_ENTITY, EntityMutationResponse.class, entity, new String[0]);
    }

    public EntityMutationResponse updateEntities(AtlasEntity.AtlasEntitiesWithExtInfo atlasEntities) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.UPDATE_ENTITIES, EntityMutationResponse.class, atlasEntities, new String[0]);
    }

    public EntityMutationResponse updateEntityByAttribute(String typeName, Map<String, String> uniqAttributes, AtlasEntity.AtlasEntityWithExtInfo entityInfo) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        return (EntityMutationResponse)this.callAPI(API_V2.UPDATE_ENTITY_BY_ATTRIBUTE, EntityMutationResponse.class, entityInfo, queryParams, new String[]{typeName});
    }

    public EntityMutationResponse partialUpdateEntityByGuid(String entityGuid, Object attrValue, String attrName) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"name", (Object)attrName);
        return (EntityMutationResponse)this.callAPI(this.formatPathParameters(API_V2.PARTIAL_UPDATE_ENTITY_BY_GUID, entityGuid), EntityMutationResponse.class, attrValue, (MultivaluedMap)queryParams, new String[0]);
    }

    public EntityMutationResponse deleteEntityByGuid(String guid) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.DELETE_ENTITY_BY_GUID, EntityMutationResponse.class, null, new String[]{guid});
    }

    public EntityMutationResponse deleteEntityByAttribute(String typeName, Map<String, String> uniqAttributes) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        return (EntityMutationResponse)this.callAPI(API_V2.DELETE_ENTITY_BY_ATTRIBUTE, EntityMutationResponse.class, queryParams, new String[]{typeName});
    }

    public EntityMutationResponse deleteEntitiesByGuids(List<String> guids) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.DELETE_ENTITIES_BY_GUIDS, EntityMutationResponse.class, "guid", guids);
    }

    public EntityMutationResponse purgeEntitiesByGuids(Set<String> guids) throws AtlasServiceException {
        return (EntityMutationResponse)this.callAPI(API_V2.PURGE_ENTITIES_BY_GUIDS, EntityMutationResponse.class, guids, new String[0]);
    }

    public AtlasClassification.AtlasClassifications getClassifications(String guid) throws AtlasServiceException {
        return (AtlasClassification.AtlasClassifications)this.callAPI(this.formatPathParameters(API_V2.GET_CLASSIFICATIONS, guid), AtlasClassification.AtlasClassifications.class, null);
    }

    public AtlasClassification.AtlasClassifications getEntityClassifications(String entityGuid, String classificationName) throws AtlasServiceException {
        return (AtlasClassification.AtlasClassifications)this.callAPI(this.formatPathParameters(API_V2.GET_FROM_CLASSIFICATION, entityGuid, classificationName), AtlasClassification.AtlasClassifications.class, null);
    }

    public void addClassification(ClassificationAssociateRequest request) throws AtlasServiceException {
        this.callAPI(API_V2.ADD_CLASSIFICATION, null, request, new String[0]);
    }

    public void addClassifications(String guid, List<AtlasClassification> classifications) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.ADD_CLASSIFICATIONS, guid), null, classifications, null);
    }

    public void addClassifications(String typeName, Map<String, String> uniqAttributes, List<AtlasClassification> classifications) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        this.callAPI(this.formatPathParameters(API_V2.ADD_CLASSIFICATION_BY_TYPE_AND_ATTRIBUTE, typeName), null, classifications, queryParams, new String[0]);
    }

    public void updateClassifications(String guid, List<AtlasClassification> classifications) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.UPDATE_CLASSIFICATIONS, guid), null, classifications, new String[0]);
    }

    public void updateClassifications(String typeName, Map<String, String> uniqAttributes, List<AtlasClassification> classifications) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        this.callAPI(this.formatPathParameters(API_V2.UPDATE_CLASSIFICATION_BY_TYPE_AND_ATTRIBUTE, typeName), null, classifications, queryParams, new String[0]);
    }

    public String setClassifications(AtlasEntityHeaders entityHeaders) throws AtlasServiceException {
        return (String)this.callAPI(API_V2.UPDATE_BULK_SET_CLASSIFICATIONS, String.class, entityHeaders, new String[0]);
    }

    public void deleteClassification(String guid, String classificationName) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_CLASSIFICATION, guid, classificationName), null, null);
    }

    public void deleteClassifications(String guid, List<AtlasClassification> classifications) throws AtlasServiceException {
        for (AtlasClassification c : classifications) {
            this.callAPI(this.formatPathParameters(API_V2.DELETE_CLASSIFICATION, guid, c.getTypeName()), null, null);
        }
    }

    public void removeClassification(String entityGuid, String classificationName, String associatedEntityGuid) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_CLASSIFICATION, entityGuid, classificationName), null, associatedEntityGuid, new String[0]);
    }

    public void removeClassification(String typeName, Map<String, String> uniqAttributes, String classificationName) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        this.callAPI(this.formatPathParameters(API_V2.DELETE_CLASSIFICATION_BY_TYPE_AND_ATTRIBUTE, typeName, classificationName), null, queryParams);
    }

    public AtlasEntityHeaders getEntityHeaders(long tagUpdateStartTime) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"tagUpdateStartTime", (Object)Long.toString(tagUpdateStartTime));
        return (AtlasEntityHeaders)this.callAPI(API_V2.GET_BULK_HEADERS, AtlasEntityHeaders.class, (MultivaluedMap)queryParams);
    }

    public void addOrUpdateBusinessAttributes(String entityGuid, boolean isOverwrite, Map<String, Map<String, Object>> businessAttributes) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"isOverwrite", (Object)String.valueOf(isOverwrite));
        this.callAPI(this.formatPathParameters(API_V2.ADD_BUSINESS_ATTRIBUTE, entityGuid), null, businessAttributes, (MultivaluedMap)queryParams, new String[0]);
    }

    public void addOrUpdateBusinessAttributes(String entityGuid, String bmName, Map<String, Map<String, Object>> businessAttributes) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.ADD_BUSINESS_ATTRIBUTE_BY_NAME, entityGuid, bmName), null, businessAttributes, new String[0]);
    }

    public void removeBusinessAttributes(String entityGuid, Map<String, Map<String, Object>> businessAttributes) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_BUSINESS_ATTRIBUTE, entityGuid), null, businessAttributes, new String[0]);
    }

    public void removeBusinessAttributes(String entityGuid, String bmName, Map<String, Map<String, Object>> businessAttributes) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_BUSINESS_ATTRIBUTE_BY_NAME, entityGuid, bmName), null, businessAttributes, new String[0]);
    }

    public String getTemplateForBulkUpdateBusinessAttributes() throws AtlasServiceException {
        InputStream inputStream = (InputStream)this.callAPI(API_V2.GET_BUSINESS_METADATA_TEMPLATE, Object.class, null);
        return this.readStreamContents(inputStream);
    }

    public BulkImportResponse bulkUpdateBusinessAttributes(String fileName) throws AtlasServiceException {
        MultiPart multipartEntity = this.getMultiPartData(fileName);
        return (BulkImportResponse)this.callAPI(API_V2.IMPORT_BUSINESS_METADATA, BulkImportResponse.class, multipartEntity, new String[0]);
    }

    public void addLabels(String entityGuid, Set<String> labels) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.ADD_LABELS, entityGuid), null, labels, null);
    }

    public void addLabels(String typeName, Map<String, String> uniqAttributes, Set<String> labels) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        this.callAPI(this.formatPathParameters(API_V2.SET_LABELS_BY_UNIQUE_ATTRIBUTE, typeName), null, labels, queryParams, new String[0]);
    }

    public void removeLabels(String entityGuid, Set<String> labels) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_LABELS, entityGuid), null, labels, new String[0]);
    }

    public void removeLabels(String typeName, Map<String, String> uniqAttributes, Set<String> labels) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        this.callAPI(this.formatPathParameters(API_V2.DELETE_LABELS_BY_UNIQUE_ATTRIBUTE, typeName), null, labels, queryParams, new String[0]);
    }

    public void setLabels(String entityGuid, Set<String> labels) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.SET_LABELS, entityGuid), null, labels, null);
    }

    public void setLabels(String typeName, Map<String, String> uniqAttributes, Set<String> labels) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(uniqAttributes);
        this.callAPI(this.formatPathParameters(API_V2.ADD_LABELS_BY_UNIQUE_ATTRIBUTE, typeName), null, labels, queryParams, new String[0]);
    }

    public AtlasLineageInfo getLineageInfo(String guid, AtlasLineageInfo.LineageDirection direction, int depth) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"direction", (Object)direction.toString());
        queryParams.add((Object)"depth", (Object)String.valueOf(depth));
        return (AtlasLineageInfo)this.callAPI(API_V2.LINEAGE_INFO, AtlasLineageInfo.class, (MultivaluedMap)queryParams, new String[]{guid});
    }

    public AtlasLineageInfo getLineageInfo(String typeName, Map<String, String> attributes, AtlasLineageInfo.LineageDirection direction, int depth) throws AtlasServiceException {
        MultivaluedMap<String, String> queryParams = this.attributesToQueryParams(attributes);
        queryParams.add((Object)"direction", (Object)direction.toString());
        queryParams.add((Object)"depth", (Object)String.valueOf(depth));
        return (AtlasLineageInfo)this.callAPI(API_V2.GET_LINEAGE_BY_ATTRIBUTES, AtlasLineageInfo.class, queryParams, new String[]{typeName});
    }

    public AtlasSearchResult dslSearch(String query) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        return (AtlasSearchResult)this.callAPI(API_V2.DSL_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult dslSearchWithParams(String query, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasSearchResult)this.callAPI(API_V2.DSL_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult fullTextSearch(String query) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        return (AtlasSearchResult)this.callAPI(API_V2.FULL_TEXT_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult fullTextSearchWithParams(String query, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasSearchResult)this.callAPI(API_V2.FULL_TEXT_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult basicSearch(String typeName, String classification, String query, boolean excludeDeletedEntities, int limit, int offset) throws AtlasServiceException {
        return this.basicSearch(typeName, null, classification, query, excludeDeletedEntities, limit, offset);
    }

    public AtlasSearchResult basicSearch(String typeName, SearchParameters.FilterCriteria entityFilters, String classification, String query, boolean excludeDeletedEntities, int limit, int offset) throws AtlasServiceException {
        SearchParameters parameters = new SearchParameters();
        parameters.setTypeName(typeName);
        parameters.setClassification(classification);
        parameters.setQuery(query);
        parameters.setExcludeDeletedEntities(excludeDeletedEntities);
        parameters.setLimit(limit);
        parameters.setOffset(offset);
        if (entityFilters != null) {
            parameters.setEntityFilters(entityFilters);
        }
        return (AtlasSearchResult)this.callAPI(API_V2.BASIC_SEARCH, AtlasSearchResult.class, parameters, new String[0]);
    }

    public AtlasSearchResult facetedSearch(SearchParameters searchParameters) throws AtlasServiceException {
        return (AtlasSearchResult)this.callAPI(API_V2.FACETED_SEARCH, AtlasSearchResult.class, searchParameters, new String[0]);
    }

    public AtlasSearchResult attributeSearch(String typeName, String attrName, String attrValuePrefix, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"attrName", (Object)attrName);
        queryParams.add((Object)"attrValuePrefix", (Object)attrValuePrefix);
        queryParams.add((Object)"typeName", (Object)typeName);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasSearchResult)this.callAPI(API_V2.ATTRIBUTE_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult relationshipSearch(String guid, String relation, String sortByAttribute, SortOrder sortOrder, boolean excludeDeletedEntities, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"guid", (Object)guid);
        queryParams.add((Object)"relation", (Object)relation);
        queryParams.add((Object)"sortBy", (Object)sortByAttribute);
        if (sortOrder != null) {
            queryParams.add((Object)"sortOrder", (Object)String.valueOf(sortOrder));
        }
        queryParams.add((Object)"excludeDeletedEntities", (Object)String.valueOf(excludeDeletedEntities));
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasSearchResult)this.callAPI(API_V2.RELATIONSHIP_SEARCH, AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasQuickSearchResult quickSearch(String query, String typeName, boolean excludeDeletedEntities, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"query", (Object)query);
        queryParams.add((Object)"typeName", (Object)typeName);
        queryParams.add((Object)"excludeDeletedEntities", (Object)String.valueOf(excludeDeletedEntities));
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (AtlasQuickSearchResult)this.callAPI(API_V2.QUICK_SEARCH_WITH_GET, AtlasQuickSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasQuickSearchResult quickSearch(QuickSearchParameters quickSearchParameters) throws AtlasServiceException {
        return (AtlasQuickSearchResult)this.callAPI(API_V2.QUICK_SEARCH_WITH_POST, AtlasQuickSearchResult.class, quickSearchParameters, new String[0]);
    }

    public AtlasSuggestionsResult getSuggestions(String prefixString, String fieldName) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        if (StringUtils.isNotEmpty((String)prefixString)) {
            queryParams.add((Object)"prefixString", (Object)prefixString);
        }
        if (StringUtils.isNotEmpty((String)fieldName)) {
            queryParams.add((Object)"fieldName", (Object)fieldName);
        }
        return (AtlasSuggestionsResult)this.callAPI(API_V2.GET_SUGGESTIONS, AtlasSuggestionsResult.class, (MultivaluedMap)queryParams);
    }

    public List<AtlasUserSavedSearch> getSavedSearches(String userName) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"user", (Object)userName);
        return (List)this.callAPI(API_V2.GET_SAVED_SEARCHES, List.class, (MultivaluedMap)queryParams);
    }

    public AtlasUserSavedSearch getSavedSearch(String userName, String searchName) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"user", (Object)userName);
        return (AtlasUserSavedSearch)this.callAPI(this.formatPathParameters(API_V2.GET_SAVED_SEARCH, searchName), AtlasUserSavedSearch.class, (MultivaluedMap)queryParams);
    }

    public AtlasUserSavedSearch addSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasServiceException {
        return (AtlasUserSavedSearch)this.callAPI(API_V2.ADD_SAVED_SEARCH, AtlasUserSavedSearch.class, savedSearch, new String[0]);
    }

    public AtlasUserSavedSearch updateSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasServiceException {
        return (AtlasUserSavedSearch)this.callAPI(API_V2.UPDATE_SAVED_SEARCH, AtlasUserSavedSearch.class, savedSearch, new String[0]);
    }

    public void deleteSavedSearch(String guid) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_SAVED_SEARCH, guid), null, null);
    }

    public AtlasSearchResult executeSavedSearch(String userName, String searchName) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"user", (Object)userName);
        return (AtlasSearchResult)this.callAPI(this.formatPathParameters(API_V2.EXECUTE_SAVED_SEARCH_BY_NAME, searchName), AtlasSearchResult.class, (MultivaluedMap)queryParams);
    }

    public AtlasSearchResult executeSavedSearch(String searchGuid) throws AtlasServiceException {
        return (AtlasSearchResult)this.callAPI(this.formatPathParameters(API_V2.EXECUTE_SAVED_SEARCH_BY_GUID, searchGuid), AtlasSearchResult.class, null);
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo getRelationshipByGuid(String guid) throws AtlasServiceException {
        return (AtlasRelationship.AtlasRelationshipWithExtInfo)this.callAPI(API_V2.GET_RELATIONSHIP_BY_GUID, AtlasRelationship.AtlasRelationshipWithExtInfo.class, null, new String[]{guid});
    }

    public AtlasRelationship.AtlasRelationshipWithExtInfo getRelationshipByGuid(String guid, boolean extendedInfo) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"extendedInfo", (Object)String.valueOf(extendedInfo));
        return (AtlasRelationship.AtlasRelationshipWithExtInfo)this.callAPI(API_V2.GET_RELATIONSHIP_BY_GUID, AtlasRelationship.AtlasRelationshipWithExtInfo.class, (MultivaluedMap)queryParams, new String[]{guid});
    }

    public AtlasRelationship createRelationship(AtlasRelationship relationship) throws AtlasServiceException {
        return (AtlasRelationship)this.callAPI(API_V2.CREATE_RELATIONSHIP, AtlasRelationship.class, relationship, new String[0]);
    }

    public AtlasRelationship updateRelationship(AtlasRelationship relationship) throws AtlasServiceException {
        return (AtlasRelationship)this.callAPI(API_V2.UPDATE_RELATIONSHIP, AtlasRelationship.class, relationship, new String[0]);
    }

    public void deleteRelationshipByGuid(String guid) throws AtlasServiceException {
        this.callAPI(API_V2.DELETE_RELATIONSHIP_BY_GUID, null, null, new String[]{guid});
    }

    public List<AtlasAuditEntry> getAtlasAuditByOperation(AuditSearchParameters auditSearchParameters) throws AtlasServiceException {
        ArrayNode response = (ArrayNode)this.callAPI(API_V2.GET_ATLAS_AUDITS, ArrayNode.class, auditSearchParameters, new String[0]);
        return this.extractResults(response, new ExtractOperation<AtlasAuditEntry, ObjectNode>(){

            @Override
            AtlasAuditEntry extractElement(ObjectNode element) {
                return (AtlasAuditEntry)AtlasType.fromV1Json((String)element.toString(), AtlasAuditEntry.class);
            }
        });
    }

    public List<AtlasGlossary> getAllGlossaries(String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        return (List)this.callAPI(API_V2.GET_ALL_GLOSSARIES, List.class, (MultivaluedMap)queryParams);
    }

    public AtlasGlossary getGlossaryByGuid(String glossaryGuid) throws AtlasServiceException {
        return (AtlasGlossary)this.callAPI(this.formatPathParameters(API_V2.GET_GLOSSARY_BY_GUID, glossaryGuid), AtlasGlossary.class, null);
    }

    public AtlasGlossary.AtlasGlossaryExtInfo getGlossaryExtInfo(String glossaryGuid) throws AtlasServiceException {
        return (AtlasGlossary.AtlasGlossaryExtInfo)this.callAPI(this.formatPathParameters(API_V2.GET_DETAILED_GLOSSARY, glossaryGuid), AtlasGlossary.AtlasGlossaryExtInfo.class, null);
    }

    public AtlasGlossaryTerm getGlossaryTerm(String termGuid) throws AtlasServiceException {
        return (AtlasGlossaryTerm)this.callAPI(API_V2.GET_GLOSSARY_TERM, AtlasGlossaryTerm.class, null, new String[]{termGuid});
    }

    public List<AtlasGlossaryTerm> getGlossaryTerms(String glossaryGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"glossaryGuid", (Object)glossaryGuid);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (List)this.callAPI(this.formatPathParameters(API_V2.GET_GLOSSARY_TERMS, glossaryGuid), List.class, (MultivaluedMap)queryParams);
    }

    public List<AtlasRelatedTermHeader> getGlossaryTermHeaders(String glossaryGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"glossaryGuid", (Object)glossaryGuid);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (List)this.callAPI(this.formatPathParameters(API_V2.GET_GLOSSARY_TERMS_HEADERS, glossaryGuid), List.class, (MultivaluedMap)queryParams);
    }

    public AtlasGlossaryCategory getGlossaryCategory(String categoryGuid) throws AtlasServiceException {
        return (AtlasGlossaryCategory)this.callAPI(API_V2.GET_GLOSSARY_CATEGORY, AtlasGlossaryCategory.class, null, new String[]{categoryGuid});
    }

    public List<AtlasGlossaryCategory> getGlossaryCategories(String glossaryGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"glossaryGuid", (Object)glossaryGuid);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (List)this.callAPI(this.formatPathParameters(API_V2.GET_GLOSSARY_CATEGORIES, glossaryGuid), List.class, (MultivaluedMap)queryParams);
    }

    public List<AtlasRelatedCategoryHeader> getGlossaryCategoryHeaders(String glossaryGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"glossaryGuid", (Object)glossaryGuid);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (List)this.callAPI(this.formatPathParameters(API_V2.GET_GLOSSARY_CATEGORIES_HEADERS, glossaryGuid), List.class, (MultivaluedMap)queryParams);
    }

    public List<AtlasRelatedTermHeader> getCategoryTerms(String categoryGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"categoryGuid", (Object)categoryGuid);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (List)this.callAPI(this.formatPathParameters(API_V2.GET_CATEGORY_TERMS, categoryGuid), List.class, (MultivaluedMap)queryParams);
    }

    public Map<AtlasGlossaryTerm.Relation, Set<AtlasRelatedTermHeader>> getRelatedTerms(String termGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"termGuid", (Object)termGuid);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (Map)this.callAPI(this.formatPathParameters(API_V2.GET_RELATED_TERMS, termGuid), Map.class, (MultivaluedMap)queryParams);
    }

    public Map<String, List<AtlasRelatedCategoryHeader>> getRelatedCategories(String categoryGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (Map)this.callAPI(this.formatPathParameters(API_V2.GET_RELATED_CATEGORIES, categoryGuid), Map.class, (MultivaluedMap)queryParams);
    }

    public AtlasGlossary createGlossary(AtlasGlossary glossary) throws AtlasServiceException {
        return (AtlasGlossary)this.callAPI(API_V2.CREATE_GLOSSARY, AtlasGlossary.class, glossary, new String[0]);
    }

    public AtlasGlossaryTerm createGlossaryTerm(AtlasGlossaryTerm glossaryTerm) throws AtlasServiceException {
        return (AtlasGlossaryTerm)this.callAPI(API_V2.CREATE_GLOSSARY_TERM, AtlasGlossaryTerm.class, glossaryTerm, new String[0]);
    }

    public List<AtlasGlossaryTerm> createGlossaryTerms(List<AtlasGlossaryTerm> glossaryTerms) throws AtlasServiceException {
        return (List)this.callAPI(API_V2.CREATE_GLOSSARY_TERMS, List.class, glossaryTerms, new String[0]);
    }

    public AtlasGlossaryCategory createGlossaryCategory(AtlasGlossaryCategory glossaryCategory) throws AtlasServiceException {
        return (AtlasGlossaryCategory)this.callAPI(API_V2.CREATE_GLOSSARY_CATEGORY, AtlasGlossaryCategory.class, glossaryCategory, new String[0]);
    }

    public List<AtlasGlossaryCategory> createGlossaryCategories(List<AtlasGlossaryCategory> glossaryCategories) throws AtlasServiceException {
        return (List)this.callAPI(API_V2.CREATE_GLOSSARY_CATEGORIES, List.class, glossaryCategories, new String[0]);
    }

    public AtlasGlossary updateGlossaryByGuid(String glossaryGuid, AtlasGlossary updatedGlossary) throws AtlasServiceException {
        return (AtlasGlossary)this.callAPI(this.formatPathParameters(API_V2.UPDATE_GLOSSARY_BY_GUID, glossaryGuid), AtlasGlossary.class, updatedGlossary, new String[0]);
    }

    public AtlasGlossary partialUpdateGlossaryByGuid(String glossaryGuid, Map<String, String> attributes) throws AtlasServiceException {
        return (AtlasGlossary)this.callAPI(this.formatPathParameters(API_V2.UPDATE_PARTIAL_GLOSSARY, glossaryGuid), AtlasGlossary.class, attributes, new String[0]);
    }

    public AtlasGlossaryTerm updateGlossaryTermByGuid(String termGuid, AtlasGlossaryTerm glossaryTerm) throws AtlasServiceException {
        return (AtlasGlossaryTerm)this.callAPI(this.formatPathParameters(API_V2.UPDATE_GLOSSARY_TERM, termGuid), AtlasGlossaryTerm.class, glossaryTerm, new String[0]);
    }

    public AtlasGlossaryTerm partialUpdateTermByGuid(String termGuid, Map<String, String> attributes) throws AtlasServiceException {
        return (AtlasGlossaryTerm)this.callAPI(this.formatPathParameters(API_V2.UPDATE_PARTIAL_TERM, termGuid), AtlasGlossaryTerm.class, attributes, new String[0]);
    }

    public AtlasGlossaryCategory updateGlossaryCategoryByGuid(String categoryGuid, AtlasGlossaryCategory glossaryCategory) throws AtlasServiceException {
        return (AtlasGlossaryCategory)this.callAPI(this.formatPathParameters(API_V2.UPDATE_CATEGORY_BY_GUID, categoryGuid), AtlasGlossaryCategory.class, glossaryCategory, new String[0]);
    }

    public AtlasGlossaryCategory partialUpdateCategoryByGuid(String categoryGuid, Map<String, String> attributes) throws AtlasServiceException {
        return (AtlasGlossaryCategory)this.callAPI(this.formatPathParameters(API_V2.UPDATE_PARTIAL_CATEGORY, categoryGuid), AtlasGlossaryCategory.class, attributes, new String[0]);
    }

    public void deleteGlossaryByGuid(String glossaryGuid) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_GLOSSARY_BY_GUID, glossaryGuid), null, null);
    }

    public void deleteGlossaryTermByGuid(String termGuid) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_TERM_BY_GUID, termGuid), null, null);
    }

    public void deleteGlossaryCategoryByGuid(String categoryGuid) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DELETE_CATEGORY_BY_GUID, categoryGuid), null, null);
    }

    public List<AtlasRelatedObjectId> getEntitiesAssignedWithTerm(String termGuid, String sortByAttribute, int limit, int offset) throws AtlasServiceException {
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"termGuid", (Object)termGuid);
        queryParams.add((Object)"limit", (Object)String.valueOf(limit));
        queryParams.add((Object)"offset", (Object)String.valueOf(offset));
        queryParams.add((Object)"sort", (Object)sortByAttribute);
        return (List)this.callAPI(this.formatPathParameters(API_V2.GET_ENTITIES_ASSIGNED_WITH_TERM, termGuid), List.class, (MultivaluedMap)queryParams);
    }

    public void assignTermToEntities(String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.ASSIGN_TERM_TO_ENTITIES, termGuid), null, relatedObjectIds, new String[0]);
    }

    public void disassociateTermFromEntities(String termGuid, List<AtlasRelatedObjectId> relatedObjectIds) throws AtlasServiceException {
        this.callAPI(this.formatPathParameters(API_V2.DISASSOCIATE_TERM_FROM_ENTITIES, termGuid), null, relatedObjectIds, new String[0]);
    }

    public String getGlossaryImportTemplate() throws AtlasServiceException {
        InputStream inputStream = (InputStream)this.callAPI(API_V2.GET_IMPORT_GLOSSARY_TEMPLATE, Object.class, null);
        return this.readStreamContents(inputStream);
    }

    public BulkImportResponse importGlossary(String fileName) throws AtlasServiceException {
        MultiPart multipartEntity = this.getMultiPartData(fileName);
        return (BulkImportResponse)this.callAPI(API_V2.IMPORT_GLOSSARY, BulkImportResponse.class, multipartEntity, new String[0]);
    }

    protected AtlasBaseClient.API formatPathParameters(AtlasBaseClient.API api, String ... params) {
        return new AtlasBaseClient.API(String.format(api.getPath(), params), api.getMethod(), api.getExpectedStatus());
    }

    private MultiPart getMultiPartData(String fileName) throws AtlasServiceException {
        try {
            File file = new File(fileName);
            FileInputStream inputStream = new FileInputStream(file);
            FormDataContentDisposition fd = ((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"file").fileName(file.getName())).build();
            return new FormDataMultiPart().bodyPart((BodyPart)new StreamDataBodyPart("file", (InputStream)inputStream)).bodyPart((BodyPart)new FormDataBodyPart(fd, "file"));
        }
        catch (FileNotFoundException e) {
            throw new AtlasServiceException((Exception)e);
        }
    }

    private String readStreamContents(InputStream inputStream) throws AtlasServiceException {
        try {
            String template;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer sb = new StringBuffer();
            while ((template = reader.readLine()) != null) {
                sb.append(template);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new AtlasServiceException(e);
        }
    }

    private <T, U> List<T> extractResults(ArrayNode jsonResponse, ExtractOperation<T, U> extractInterafce) {
        ArrayList<T> ret = new ArrayList<T>();
        for (int index = 0; index < jsonResponse.size(); ++index) {
            JsonNode element = jsonResponse.get(index);
            ret.add(extractInterafce.extractElement(element));
        }
        return ret;
    }

    private MultivaluedMap<String, String> attributesToQueryParams(Map<String, String> attributes) {
        return this.attributesToQueryParams(attributes, null);
    }

    private MultivaluedMap<String, String> attributesToQueryParams(Map<String, String> attributes, MultivaluedMap<String, String> queryParams) {
        if (queryParams == null) {
            queryParams = new MultivaluedMapImpl();
        }
        if (MapUtils.isNotEmpty(attributes)) {
            for (Map.Entry<String, String> e : attributes.entrySet()) {
                queryParams.putSingle((Object)(PREFIX_ATTR + e.getKey()), (Object)e.getValue());
            }
        }
        return queryParams;
    }

    private MultivaluedMap<String, String> attributesToQueryParams(List<Map<String, String>> attributesList, MultivaluedMap<String, String> queryParams) {
        if (queryParams == null) {
            queryParams = new MultivaluedMapImpl();
        }
        for (int i = 0; i < attributesList.size(); ++i) {
            Map<String, String> attributes = attributesList.get(i);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                queryParams.putSingle((Object)(PREFIX_ATTR_ + i + ":" + entry.getKey()), (Object)entry.getValue());
            }
        }
        return queryParams;
    }

    private <T> T getTypeDefByName(String name, Class<T> typeDefClass) throws AtlasServiceException {
        String pathForType = this.getPathForType(typeDefClass);
        AtlasBaseClient.API api = new AtlasBaseClient.API(String.format(GET_BY_NAME_TEMPLATE, pathForType, name), "GET", Response.Status.OK);
        return (T)this.callAPI(api, typeDefClass, null);
    }

    private <T> T getTypeDefByGuid(String guid, Class<T> typeDefClass) throws AtlasServiceException {
        String pathForType = this.getPathForType(typeDefClass);
        AtlasBaseClient.API api = new AtlasBaseClient.API(String.format(GET_BY_GUID_TEMPLATE, pathForType, guid), "GET", Response.Status.OK);
        return (T)this.callAPI(api, typeDefClass, null);
    }

    protected <T> String getPathForType(Class<T> typeDefClass) {
        if (AtlasEnumDef.class.isAssignableFrom(typeDefClass)) {
            return "enumdef";
        }
        if (AtlasEntityDef.class.isAssignableFrom(typeDefClass)) {
            return "entitydef";
        }
        if (AtlasClassificationDef.class.isAssignableFrom(typeDefClass)) {
            return "classificationdef";
        }
        if (AtlasRelationshipDef.class.isAssignableFrom(typeDefClass)) {
            return "relationshipdef";
        }
        if (AtlasBusinessMetadataDef.class.isAssignableFrom(typeDefClass)) {
            return "businessmetadatadef";
        }
        if (AtlasStructDef.class.isAssignableFrom(typeDefClass)) {
            return "structdef";
        }
        return "";
    }

    public static class API_V2
    extends AtlasBaseClient.API {
        public static final API_V2 GET_TYPEDEF_BY_NAME = new API_V2("api/atlas/v2/types/typedef/name/", "GET", Response.Status.OK);
        public static final API_V2 GET_TYPEDEF_BY_GUID = new API_V2("api/atlas/v2/types/typedef/guid/", "GET", Response.Status.OK);
        public static final API_V2 GET_ALL_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "GET", Response.Status.OK);
        public static final API_V2 GET_ALL_TYPE_DEF_HEADERS = new API_V2("api/atlas/v2/types/typedefs/headers", "GET", Response.Status.OK);
        public static final API_V2 CREATE_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_TYPE_DEFS = new API_V2("api/atlas/v2/types/typedefs/", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_TYPE_DEF_BY_NAME = new API_V2("api/atlas/v2/types/typedef/name/", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 GET_ENTITY_BY_GUID = new API_V2("api/atlas/v2/entity/guid/", "GET", Response.Status.OK);
        public static final API_V2 GET_ENTITY_BY_UNIQUE_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/", "GET", Response.Status.OK);
        public static final API_V2 GET_ENTITIES_BY_GUIDS = new API_V2("api/atlas/v2/entity/bulk/", "GET", Response.Status.OK);
        public static final API_V2 GET_ENTITIES_BY_UNIQUE_ATTRIBUTE = new API_V2("api/atlas/v2/entity/bulk/uniqueAttribute/type/", "GET", Response.Status.OK);
        public static final API_V2 GET_ENTITY_HEADER_BY_GUID = new API_V2("api/atlas/v2/entity/guid/%s/header", "GET", Response.Status.OK);
        public static final API_V2 GET_ENTITY_HEADER_BY_UNIQUE_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/%s/header", "GET", Response.Status.OK);
        public static final API_V2 GET_AUDIT_EVENTS = new API_V2("api/atlas/v2/entity/%s/audit", "GET", Response.Status.OK);
        public static final API_V2 CREATE_ENTITY = new API_V2("api/atlas/v2/entity/", "POST", Response.Status.OK);
        public static final API_V2 CREATE_ENTITIES = new API_V2("api/atlas/v2/entity/bulk/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_ENTITY = new API_V2("api/atlas/v2/entity/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_ENTITY_BY_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/", "PUT", Response.Status.OK);
        public static final API_V2 UPDATE_ENTITIES = new API_V2("api/atlas/v2/entity/bulk/", "POST", Response.Status.OK);
        public static final API_V2 PARTIAL_UPDATE_ENTITY_BY_GUID = new API_V2("api/atlas/v2/entity/guid/%s", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_ENTITY_BY_GUID = new API_V2("api/atlas/v2/entity/guid/", "DELETE", Response.Status.OK);
        public static final API_V2 DELETE_ENTITY_BY_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/", "DELETE", Response.Status.OK);
        public static final API_V2 DELETE_ENTITIES_BY_GUIDS = new API_V2("api/atlas/v2/entity/bulk/", "DELETE", Response.Status.OK);
        public static final API_V2 PURGE_ENTITIES_BY_GUIDS = new API_V2("api/atlas/admin/purge/", "PUT", Response.Status.OK);
        public static final API_V2 GET_CLASSIFICATIONS = new API_V2("api/atlas/v2/entity/guid/%s/classifications", "GET", Response.Status.OK);
        public static final API_V2 GET_FROM_CLASSIFICATION = new API_V2("api/atlas/v2/entity/guid/%s/classification/%s", "GET", Response.Status.OK);
        public static final API_V2 ADD_CLASSIFICATIONS = new API_V2("api/atlas/v2/entity/guid/%s/classifications", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 ADD_CLASSIFICATION = new API_V2("api/atlas/v2/entity/bulk//classification", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 ADD_CLASSIFICATION_BY_TYPE_AND_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/%s/classifications", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 UPDATE_CLASSIFICATIONS = new API_V2("api/atlas/v2/entity/guid/%s/classifications", "PUT", Response.Status.NO_CONTENT);
        public static final API_V2 UPDATE_CLASSIFICATION_BY_TYPE_AND_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/%s/classifications", "PUT", Response.Status.NO_CONTENT);
        public static final API_V2 UPDATE_BULK_SET_CLASSIFICATIONS = new API_V2("api/atlas/v2/entity/bulk/setClassifications", "POST", Response.Status.OK);
        public static final API_V2 DELETE_CLASSIFICATION = new API_V2("api/atlas/v2/entity/guid/%s/classification/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_CLASSIFICATION_BY_TYPE_AND_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/%s/classification/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 GET_BULK_HEADERS = new API_V2("api/atlas/v2/entity/bulk/headers", "GET", Response.Status.OK);
        public static final API_V2 ADD_BUSINESS_ATTRIBUTE = new API_V2("api/atlas/v2/entity/guid/%s/businessmetadata", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 ADD_BUSINESS_ATTRIBUTE_BY_NAME = new API_V2("api/atlas/v2/entity/guid/%s/businessmetadata/%s", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_BUSINESS_ATTRIBUTE = new API_V2("api/atlas/v2/entity/guid/%s/businessmetadata", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_BUSINESS_ATTRIBUTE_BY_NAME = new API_V2("api/atlas/v2/entity/guid/%s/businessmetadata/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 GET_BUSINESS_METADATA_TEMPLATE = new API_V2("api/atlas/v2/entity/businessmetadata/import/template", "GET", Response.Status.OK, "application/json", "application/octet-stream");
        public static final API_V2 IMPORT_BUSINESS_METADATA = new API_V2("api/atlas/v2/entity/businessmetadata/import", "POST", Response.Status.OK, "multipart/form-data", "application/json");
        public static final API_V2 ADD_LABELS = new API_V2("api/atlas/v2/entity/guid/%s/labels", "PUT", Response.Status.NO_CONTENT);
        public static final API_V2 ADD_LABELS_BY_UNIQUE_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/%s/labels", "PUT", Response.Status.NO_CONTENT);
        public static final API_V2 SET_LABELS = new API_V2("api/atlas/v2/entity/guid/%s/labels", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 SET_LABELS_BY_UNIQUE_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/%s/labels", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_LABELS = new API_V2("api/atlas/v2/entity/guid/%s/labels", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_LABELS_BY_UNIQUE_ATTRIBUTE = new API_V2("api/atlas/v2/entity/uniqueAttribute/type/%s/labels", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 LINEAGE_INFO = new API_V2("api/atlas/v2/lineage/", "GET", Response.Status.OK);
        public static final API_V2 GET_LINEAGE_BY_ATTRIBUTES = new API_V2("api/atlas/v2/lineage/uniqueAttribute/type/", "GET", Response.Status.OK);
        public static final API_V2 DSL_SEARCH = new API_V2("api/atlas/v2/search/dsl", "GET", Response.Status.OK);
        public static final API_V2 FULL_TEXT_SEARCH = new API_V2("api/atlas/v2/search/fulltext", "GET", Response.Status.OK);
        public static final API_V2 BASIC_SEARCH = new API_V2("api/atlas/v2/search/basic", "POST", Response.Status.OK);
        public static final API_V2 FACETED_SEARCH = new API_V2("api/atlas/v2/search/basic", "POST", Response.Status.OK);
        public static final API_V2 ATTRIBUTE_SEARCH = new API_V2("api/atlas/v2/search/attribute", "GET", Response.Status.OK);
        public static final API_V2 RELATIONSHIP_SEARCH = new API_V2("api/atlas/v2/search/relationship", "GET", Response.Status.OK);
        public static final API_V2 QUICK_SEARCH_WITH_GET = new API_V2("api/atlas/v2/search/quick", "GET", Response.Status.OK);
        public static final API_V2 QUICK_SEARCH_WITH_POST = new API_V2("api/atlas/v2/search/quick", "POST", Response.Status.OK);
        public static final API_V2 GET_SUGGESTIONS = new API_V2("api/atlas/v2/search/suggestions", "GET", Response.Status.OK);
        public static final API_V2 GET_SAVED_SEARCHES = new API_V2("api/atlas/v2/search/saved", "GET", Response.Status.OK);
        public static final API_V2 GET_SAVED_SEARCH = new API_V2("api/atlas/v2/search/saved/%s", "GET", Response.Status.OK);
        public static final API_V2 ADD_SAVED_SEARCH = new API_V2("api/atlas/v2/search/saved", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_SAVED_SEARCH = new API_V2("api/atlas/v2/search/saved", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_SAVED_SEARCH = new API_V2("api/atlas/v2/search/saved/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 EXECUTE_SAVED_SEARCH_BY_NAME = new API_V2("api/atlas/v2/search/saved/execute/%s", "GET", Response.Status.OK);
        public static final API_V2 EXECUTE_SAVED_SEARCH_BY_GUID = new API_V2("api/atlas/v2/search/saved/execute/guid/%s", "GET", Response.Status.OK);
        public static final API_V2 GET_RELATIONSHIP_BY_GUID = new API_V2("api/atlas/v2/relationship/guid/", "GET", Response.Status.OK);
        public static final API_V2 CREATE_RELATIONSHIP = new API_V2("api/atlas/v2/relationship/", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_RELATIONSHIP = new API_V2("api/atlas/v2/relationship/", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_RELATIONSHIP_BY_GUID = new API_V2("api/atlas/v2/relationship/guid/", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 GET_ATLAS_AUDITS = new API_V2("api/atlas/admin/audits/", "POST", Response.Status.OK);
        public static final API_V2 GET_ALL_GLOSSARIES = new API_V2("api/atlas/v2/glossary", "GET", Response.Status.OK);
        public static final API_V2 GET_GLOSSARY_BY_GUID = new API_V2("api/atlas/v2/glossary/%s", "GET", Response.Status.OK);
        public static final API_V2 GET_DETAILED_GLOSSARY = new API_V2("api/atlas/v2/glossary/%s/detailed", "GET", Response.Status.OK);
        public static final API_V2 GET_GLOSSARY_TERM = new API_V2("api/atlas/v2/glossary/term", "GET", Response.Status.OK);
        public static final API_V2 GET_GLOSSARY_TERMS = new API_V2("api/atlas/v2/glossary/%s/terms", "GET", Response.Status.OK);
        public static final API_V2 GET_GLOSSARY_TERMS_HEADERS = new API_V2("api/atlas/v2/glossary/%s/terms/headers", "GET", Response.Status.OK);
        public static final API_V2 GET_GLOSSARY_CATEGORY = new API_V2("api/atlas/v2/glossary/category", "GET", Response.Status.OK);
        public static final API_V2 GET_GLOSSARY_CATEGORIES = new API_V2("api/atlas/v2/glossary/%s/categories", "GET", Response.Status.OK);
        public static final API_V2 GET_GLOSSARY_CATEGORIES_HEADERS = new API_V2("api/atlas/v2/glossary/%s/categories/headers", "GET", Response.Status.OK);
        public static final API_V2 GET_CATEGORY_TERMS = new API_V2("api/atlas/v2/glossary/category/%s/terms", "GET", Response.Status.OK);
        public static final API_V2 GET_RELATED_TERMS = new API_V2("api/atlas/v2/glossary/terms/%s/related", "GET", Response.Status.OK);
        public static final API_V2 GET_RELATED_CATEGORIES = new API_V2("api/atlas/v2/glossary/category/%s/related", "GET", Response.Status.OK);
        public static final API_V2 CREATE_GLOSSARY = new API_V2("api/atlas/v2/glossary", "POST", Response.Status.OK);
        public static final API_V2 CREATE_GLOSSARY_TERM = new API_V2("api/atlas/v2/glossary/term", "POST", Response.Status.OK);
        public static final API_V2 CREATE_GLOSSARY_TERMS = new API_V2("api/atlas/v2/glossary/terms", "POST", Response.Status.OK);
        public static final API_V2 CREATE_GLOSSARY_CATEGORY = new API_V2("api/atlas/v2/glossary/category", "POST", Response.Status.OK);
        public static final API_V2 CREATE_GLOSSARY_CATEGORIES = new API_V2("api/atlas/v2/glossary/categories", "POST", Response.Status.OK);
        public static final API_V2 UPDATE_GLOSSARY_BY_GUID = new API_V2("api/atlas/v2/glossary/%s", "PUT", Response.Status.OK);
        public static final API_V2 UPDATE_PARTIAL_GLOSSARY = new API_V2("api/atlas/v2/glossary/%s/partial", "PUT", Response.Status.OK);
        public static final API_V2 UPDATE_GLOSSARY_TERM = new API_V2("api/atlas/v2/glossary/term/%s", "PUT", Response.Status.OK);
        public static final API_V2 UPDATE_PARTIAL_TERM = new API_V2("api/atlas/v2/glossary/term/%s/partial", "PUT", Response.Status.OK);
        public static final API_V2 UPDATE_CATEGORY_BY_GUID = new API_V2("api/atlas/v2/glossary/category/%s", "PUT", Response.Status.OK);
        public static final API_V2 UPDATE_PARTIAL_CATEGORY = new API_V2("api/atlas/v2/glossary/category/%s/partial", "PUT", Response.Status.OK);
        public static final API_V2 DELETE_GLOSSARY_BY_GUID = new API_V2("api/atlas/v2/glossary/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_TERM_BY_GUID = new API_V2("api/atlas/v2/glossary/term/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 DELETE_CATEGORY_BY_GUID = new API_V2("api/atlas/v2/glossary/category/%s", "DELETE", Response.Status.NO_CONTENT);
        public static final API_V2 GET_ENTITIES_ASSIGNED_WITH_TERM = new API_V2("api/atlas/v2/glossary/terms/%s/assignedEntities", "GET", Response.Status.OK);
        public static final API_V2 ASSIGN_TERM_TO_ENTITIES = new API_V2("api/atlas/v2/glossary/terms/%s/assignedEntities", "POST", Response.Status.NO_CONTENT);
        public static final API_V2 DISASSOCIATE_TERM_FROM_ENTITIES = new API_V2("api/atlas/v2/glossary/terms/%s/assignedEntities", "PUT", Response.Status.NO_CONTENT);
        public static final API_V2 GET_IMPORT_GLOSSARY_TEMPLATE = new API_V2("api/atlas/v2/glossary/import/template", "GET", Response.Status.OK, "application/json", "application/octet-stream");
        public static final API_V2 IMPORT_GLOSSARY = new API_V2("api/atlas/v2/glossary/import", "POST", Response.Status.OK, "multipart/form-data", "application/json");

        private API_V2(String path, String method, Response.Status status) {
            super(path, method, status);
        }

        private API_V2(String path, String method, Response.Status status, String consumes, String produces) {
            super(path, method, status, consumes, produces);
        }
    }

    private class ExtractOperation<T, U> {
        private ExtractOperation() {
        }

        T extractElement(U element) {
            return (T)element;
        }
    }
}

