/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.janus.GraphDbObjectFactory;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphVertex;

public class AtlasJanusIndexQuery
implements AtlasIndexQuery<AtlasJanusVertex, AtlasJanusEdge> {
    private AtlasJanusGraph graph;
    private JanusGraphIndexQuery query;

    public AtlasJanusIndexQuery(AtlasJanusGraph graph, JanusGraphIndexQuery query) {
        this.query = query;
        this.graph = graph;
    }

    public Iterator<AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> vertices() {
        Iterator results = this.query.vertices().iterator();
        Function<JanusGraphIndexQuery.Result<JanusGraphVertex>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> function = new Function<JanusGraphIndexQuery.Result<JanusGraphVertex>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>>(){

            public AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge> apply(JanusGraphIndexQuery.Result<JanusGraphVertex> source) {
                return new ResultImpl(source);
            }
        };
        return Iterators.transform(results, (Function)function);
    }

    public Iterator<AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> vertices(int offset, int limit) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Index offset should be greater than or equals to 0");
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Index limit should be greater than or equals to 0");
        Iterator results = this.query.offset(offset).limit(limit).vertices().iterator();
        Function<JanusGraphIndexQuery.Result<JanusGraphVertex>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> function = new Function<JanusGraphIndexQuery.Result<JanusGraphVertex>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>>(){

            public AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge> apply(JanusGraphIndexQuery.Result<JanusGraphVertex> source) {
                return new ResultImpl(source);
            }
        };
        return Iterators.transform(results, (Function)function);
    }

    public Iterator<AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> vertices(int offset, int limit, String sortBy, Order sortOrder) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Index offset should be greater than or equals to 0");
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Index limit should be greater than or equals to 0");
        Iterator results = this.query.orderBy(sortBy, sortOrder).offset(offset).limit(limit).vertices().iterator();
        Function<JanusGraphIndexQuery.Result<JanusGraphVertex>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> function = new Function<JanusGraphIndexQuery.Result<JanusGraphVertex>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>>(){

            public AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge> apply(JanusGraphIndexQuery.Result<JanusGraphVertex> source) {
                return new ResultImpl(source);
            }
        };
        return Iterators.transform(results, (Function)function);
    }

    public Long vertexTotals() {
        return this.query.vertexTotals();
    }

    public Long edgeTotals() {
        return this.query.edgeTotals();
    }

    public Iterator<AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> edges() {
        Iterator results = this.query.edges().iterator();
        Function<JanusGraphIndexQuery.Result<JanusGraphEdge>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> function = new Function<JanusGraphIndexQuery.Result<JanusGraphEdge>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>>(){

            public AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge> apply(JanusGraphIndexQuery.Result<JanusGraphEdge> source) {
                return new ResultImpl(source, null);
            }
        };
        return Iterators.transform(results, (Function)function);
    }

    public Iterator<AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> edges(int offset, int limit) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Index offset should be greater than or equals to 0");
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Index limit should be greater than or equals to 0");
        Iterator results = this.query.offset(offset).limit(limit).edges().iterator();
        Function<JanusGraphIndexQuery.Result<JanusGraphEdge>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> function = new Function<JanusGraphIndexQuery.Result<JanusGraphEdge>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>>(){

            public AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge> apply(JanusGraphIndexQuery.Result<JanusGraphEdge> source) {
                return new ResultImpl(source, null);
            }
        };
        return Iterators.transform(results, (Function)function);
    }

    public Iterator<AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> edges(int offset, int limit, String sortBy, Order sortOrder) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Index offset should be greater than or equals to 0");
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Index limit should be greater than or equals to 0");
        Iterator results = this.query.orderBy(sortBy, sortOrder).offset(offset).limit(limit).edges().iterator();
        Function<JanusGraphIndexQuery.Result<JanusGraphEdge>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>> function = new Function<JanusGraphIndexQuery.Result<JanusGraphEdge>, AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge>>(){

            public AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge> apply(JanusGraphIndexQuery.Result<JanusGraphEdge> source) {
                return new ResultImpl(source, null);
            }
        };
        return Iterators.transform(results, (Function)function);
    }

    public final class ResultImpl
    implements AtlasIndexQuery.Result<AtlasJanusVertex, AtlasJanusEdge> {
        private JanusGraphIndexQuery.Result<JanusGraphVertex> vertex;
        private JanusGraphIndexQuery.Result<JanusGraphEdge> edge;

        public ResultImpl(JanusGraphIndexQuery.Result<JanusGraphVertex> source) {
            this.vertex = source;
        }

        public ResultImpl(JanusGraphIndexQuery.Result<JanusGraphEdge> source, AtlasJanusEdge edge) {
            this.edge = source;
        }

        public AtlasVertex<AtlasJanusVertex, AtlasJanusEdge> getVertex() {
            return GraphDbObjectFactory.createVertex(AtlasJanusIndexQuery.this.graph, (Vertex)this.vertex.getElement());
        }

        public AtlasEdge<AtlasJanusVertex, AtlasJanusEdge> getEdge() {
            return GraphDbObjectFactory.createEdge(AtlasJanusIndexQuery.this.graph, (Edge)this.edge.getElement());
        }

        public double getScore() {
            return this.vertex.getScore();
        }
    }
}

