/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.janus.migration.ElementProcessors;
import org.apache.atlas.repository.graphdb.janus.migration.MappedElementCache;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphSONUtility {
    private static final Logger LOG = LoggerFactory.getLogger(GraphSONUtility.class);
    private static final String EMPTY_STRING = "";
    private static final AtlasBuiltInTypes.AtlasBigIntegerType bigIntegerType = new AtlasBuiltInTypes.AtlasBigIntegerType();
    private static final AtlasBuiltInTypes.AtlasBigDecimalType bigDecimalType = new AtlasBuiltInTypes.AtlasBigDecimalType();
    private final ElementProcessors elementProcessors;

    public GraphSONUtility(ElementProcessors elementProcessors) {
        this.elementProcessors = elementProcessors;
    }

    public Map<String, Object> vertexFromJson(Graph g, JsonNode json) {
        Object vertexId;
        Map<String, Object> props = GraphSONUtility.readProperties(json);
        if (props.containsKey(Constants.TYPENAME_PROPERTY_KEY)) {
            return null;
        }
        Map<String, Object> schemaUpdate = null;
        Graph.Features.VertexFeatures vertexFeatures = g.features().vertex();
        Vertex vertex = vertexFeatures.willAllowId(vertexId = GraphSONUtility.getTypedValueFromJsonNode(json.get("_id"))) ? g.addVertex(new Object[]{T.id, vertexId}) : g.addVertex(new Object[0]);
        props.put("__vIdInImport", vertexId);
        this.elementProcessors.processCollections(Constants.ENTITY_TYPE_PROPERTY_KEY, props);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            try {
                VertexProperty.Cardinality cardinality = vertexFeatures.getCardinality(entry.getKey());
                String key = entry.getKey();
                Object val = entry.getValue();
                if ((cardinality == VertexProperty.Cardinality.list || cardinality == VertexProperty.Cardinality.set) && val instanceof Collection) {
                    for (Object elem : (Collection)val) {
                        vertex.property(key, elem);
                    }
                    continue;
                }
                vertex.property(key, val);
            }
            catch (IllegalArgumentException ex) {
                schemaUpdate = this.getSchemaUpdateMap(schemaUpdate);
                if (!schemaUpdate.containsKey("id")) {
                    schemaUpdate.put("id", vertex.id());
                }
                schemaUpdate.put(entry.getKey(), entry.getValue());
            }
        }
        return schemaUpdate;
    }

    public Map<String, Object> edgeFromJson(Graph g, MappedElementCache cache, JsonNode json) {
        String label;
        JsonNode nodeLabel = json.get("_label");
        String string = label = nodeLabel == null ? EMPTY_STRING : nodeLabel.textValue();
        if (label.startsWith("__type.")) {
            return null;
        }
        Map<String, Object> schemaUpdate = null;
        Object edgeId = null;
        try {
            Vertex in = this.getMappedVertex(g, cache, json, "_inV");
            Vertex out = this.getMappedVertex(g, cache, json, "_outV");
            if (in == null || out == null) {
                return null;
            }
            edgeId = GraphSONUtility.getTypedValueFromJsonNode(json.get("_id"));
            Map<String, Object> props = GraphSONUtility.readProperties(json);
            props.put("__eIdInImport", edgeId.toString());
            label = this.elementProcessors.updateEdge(in, out, edgeId, label, props);
            Graph.Features.EdgeFeatures edgeFeatures = g.features().edge();
            Edge edge = edgeFeatures.willAllowId(edgeId) ? out.addEdge(label, in, new Object[]{T.id, edgeId}) : out.addEdge(label, in, new Object[0]);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                try {
                    edge.property(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException ex) {
                    schemaUpdate = this.getSchemaUpdateMap(schemaUpdate);
                    if (!schemaUpdate.containsKey("id")) {
                        schemaUpdate.put("id", edge.id());
                    }
                    schemaUpdate.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IllegalArgumentException ex) {
            schemaUpdate = this.getSchemaUpdateMap(schemaUpdate);
            schemaUpdate.put("oid", edgeId);
        }
        return schemaUpdate;
    }

    private Map<String, Object> getSchemaUpdateMap(Map<String, Object> schemaUpdate) {
        if (schemaUpdate == null) {
            schemaUpdate = new HashMap<String, Object>();
        }
        return schemaUpdate;
    }

    private Vertex getMappedVertex(Graph gr, MappedElementCache cache, JsonNode json, String direction) {
        Object inVId = GraphSONUtility.getTypedValueFromJsonNode(json.get(direction));
        return cache.getMappedVertex(gr, inVId);
    }

    static Map<String, Object> readProperties(JsonNode node) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Object o;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (GraphSONUtility.isReservedKey((String)entry.getKey()) || (o = GraphSONUtility.readProperty((JsonNode)entry.getValue())) == null) continue;
            map.put((String)entry.getKey(), o);
        }
        return map;
    }

    private static boolean isReservedKey(String key) {
        return key.equals("_id") || key.equals("_type") || key.equals("_label") || key.equals("_outV") || key.equals("_inV");
    }

    private static Object readProperty(JsonNode node) {
        Object propertyValue = node.get("type").textValue().equals("unknown") ? null : (node.get("type").textValue().equals("boolean") ? Boolean.valueOf(node.get("value").booleanValue()) : (node.get("type").textValue().equals("float") ? Float.valueOf(Float.parseFloat(node.get("value").asText())) : (node.get("type").textValue().equals("byte") ? Byte.valueOf(Byte.parseByte(node.get("value").asText())) : (node.get("type").textValue().equals("short") ? Short.valueOf(Short.parseShort(node.get("value").asText())) : (node.get("type").textValue().equals("double") ? Double.valueOf(node.get("value").doubleValue()) : (node.get("type").textValue().equals("integer") ? Integer.valueOf(node.get("value").intValue()) : (node.get("type").textValue().equals("long") ? Long.valueOf(node.get("value").asLong()) : (node.get("type").textValue().equals("bigdecimal") ? bigDecimalType.getNormalizedValue((Object)node.get("value")) : (node.get("type").textValue().equals("biginteger") ? bigIntegerType.getNormalizedValue((Object)node.get("value")) : (node.get("type").textValue().equals("date") ? new Date(node.get("value").asLong()) : (node.get("type").textValue().equals("string") ? node.get("value").textValue() : (node.get("type").textValue().equals("list") ? GraphSONUtility.readProperties(node.get("value").elements()) : (node.get("type").textValue().equals("map") ? GraphSONUtility.readProperties(node.get("value")) : node.textValue())))))))))))));
        return propertyValue;
    }

    private static List readProperties(Iterator<JsonNode> listOfNodes) {
        ArrayList<Object> array = new ArrayList<Object>();
        while (listOfNodes.hasNext()) {
            array.add(GraphSONUtility.readProperty(listOfNodes.next()));
        }
        return array;
    }

    static Object getTypedValueFromJsonNode(JsonNode node) {
        Object theValue = null;
        if (node != null && !node.isNull()) {
            theValue = node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : (node.isDouble() ? Double.valueOf(node.doubleValue()) : (node.isFloatingPointNumber() ? Float.valueOf(node.floatValue()) : (node.isInt() ? Integer.valueOf(node.intValue()) : (node.isLong() ? Long.valueOf(node.longValue()) : (node.isTextual() ? node.textValue() : (node.isBigDecimal() ? node.decimalValue() : (node.isBigInteger() ? node.bigIntegerValue() : (node.isArray() ? node : (node.isObject() ? node : node.textValue())))))))));
        }
        return theValue;
    }
}

