/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.discovery;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.SortOrder;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String query;
    private String typeName;
    private String classification;
    private String termName;
    private String sortBy;
    private boolean excludeDeletedEntities;
    private boolean includeClassificationAttributes;
    private boolean includeSubTypes = true;
    private boolean includeSubClassifications = true;
    private boolean excludeHeaderAttributes = false;
    private int limit;
    private int offset;
    private String marker;
    private FilterCriteria entityFilters;
    private FilterCriteria tagFilters;
    private Set<String> attributes;
    private SortOrder sortOrder;
    public static final String WILDCARD_CLASSIFICATIONS = "*";
    public static final String ALL_CLASSIFICATIONS = "_CLASSIFIED";
    public static final String NO_CLASSIFICATIONS = "_NOT_CLASSIFIED";
    public static final String ALL_ENTITY_TYPES = "_ALL_ENTITY_TYPES";
    public static final String ALL_CLASSIFICATION_TYPES = "_ALL_CLASSIFICATION_TYPES";

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTermName() {
        return this.termName;
    }

    public void setTermName(String termName) {
        this.termName = termName;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public boolean getExcludeDeletedEntities() {
        return this.excludeDeletedEntities;
    }

    public void setExcludeDeletedEntities(boolean excludeDeletedEntities) {
        this.excludeDeletedEntities = excludeDeletedEntities;
    }

    public boolean getIncludeClassificationAttributes() {
        return this.includeClassificationAttributes;
    }

    public void setIncludeClassificationAttributes(boolean includeClassificationAttributes) {
        this.includeClassificationAttributes = includeClassificationAttributes;
    }

    public boolean getIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public void setIncludeSubTypes(boolean includeSubTypes) {
        this.includeSubTypes = includeSubTypes;
    }

    public boolean getIncludeSubClassifications() {
        return this.includeSubClassifications;
    }

    public void setIncludeSubClassifications(boolean includeSubClassifications) {
        this.includeSubClassifications = includeSubClassifications;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public FilterCriteria getEntityFilters() {
        return this.entityFilters;
    }

    public void setEntityFilters(FilterCriteria entityFilters) {
        this.entityFilters = entityFilters;
    }

    public FilterCriteria getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(FilterCriteria tagFilters) {
        this.tagFilters = tagFilters;
    }

    public boolean getExcludeHeaderAttributes() {
        return this.excludeHeaderAttributes;
    }

    public void setExcludeHeaderAttributes(boolean excludeHeaderAttributes) {
        this.excludeHeaderAttributes = excludeHeaderAttributes;
    }

    public Set<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<String> attributes) {
        this.attributes = attributes;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchParameters that = (SearchParameters)o;
        return this.excludeDeletedEntities == that.excludeDeletedEntities && this.includeClassificationAttributes == that.includeClassificationAttributes && this.includeSubTypes == that.includeSubTypes && this.includeSubClassifications == that.includeSubClassifications && this.excludeHeaderAttributes == that.excludeHeaderAttributes && this.limit == that.limit && this.offset == that.offset && Objects.equals(this.query, that.query) && Objects.equals(this.typeName, that.typeName) && Objects.equals(this.classification, that.classification) && Objects.equals(this.termName, that.termName) && Objects.equals(this.entityFilters, that.entityFilters) && Objects.equals(this.tagFilters, that.tagFilters) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.sortBy, that.sortBy) && Objects.equals((Object)this.sortOrder, (Object)that.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.typeName, this.classification, this.termName, this.includeSubTypes, this.includeSubClassifications, this.excludeDeletedEntities, this.includeClassificationAttributes, this.excludeHeaderAttributes, this.limit, this.offset, this.entityFilters, this.tagFilters, this.attributes, this.sortBy, this.sortOrder});
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append('{');
        sb.append("query='").append(this.query).append('\'');
        sb.append(", typeName='").append(this.typeName).append('\'');
        sb.append(", classification='").append(this.classification).append('\'');
        sb.append(", termName='").append(this.termName).append('\'');
        sb.append(", includeSubTypes='").append(this.includeSubTypes).append('\'');
        sb.append(", includeSubClassifications='").append(this.includeSubClassifications).append('\'');
        sb.append(", excludeDeletedEntities=").append(this.excludeDeletedEntities);
        sb.append(", includeClassificationAttributes=").append(this.includeClassificationAttributes);
        sb.append(", excludeHeaderAttributes=").append(this.excludeHeaderAttributes);
        sb.append(", limit=").append(this.limit);
        sb.append(", offset=").append(this.offset);
        sb.append(", entityFilters=").append(this.entityFilters);
        sb.append(", tagFilters=").append(this.tagFilters);
        sb.append(", attributes=").append(this.attributes);
        sb.append(", sortBy=").append(this.sortBy).append('\'');
        sb.append(", sortOrder=").append((Object)this.sortOrder).append('\'');
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static enum Operator {
        LT(new String[]{"<", "lt"}),
        GT(new String[]{">", "gt"}),
        LTE(new String[]{"<=", "lte"}),
        GTE(new String[]{">=", "gte"}),
        EQ(new String[]{"=", "eq"}),
        NEQ(new String[]{"!=", "neq"}),
        IN(new String[]{"in", "IN"}),
        LIKE(new String[]{"like", "LIKE"}),
        STARTS_WITH(new String[]{"startsWith", "STARTSWITH", "begins_with", "BEGINS_WITH"}),
        ENDS_WITH(new String[]{"endsWith", "ENDSWITH", "ends_with", "ENDS_WITH"}),
        CONTAINS(new String[]{"contains", "CONTAINS"}),
        NOT_CONTAINS(new String[]{"not_contains", "NOT_CONTAINS"}),
        CONTAINS_ANY(new String[]{"containsAny", "CONTAINSANY", "contains_any", "CONTAINS_ANY"}),
        CONTAINS_ALL(new String[]{"containsAll", "CONTAINSALL", "contains_all", "CONTAINS_ALL"}),
        IS_NULL(new String[]{"isNull", "ISNULL", "is_null", "IS_NULL"}),
        NOT_NULL(new String[]{"notNull", "NOTNULL", "not_null", "NOT_NULL"}),
        TIME_RANGE(new String[]{"timerange", "TIMERANGE", "time_range", "TIME_RANGE"}),
        NOT_EMPTY(new String[]{"notEmpty", "NOTEMPTY", "not_empty", "NOT_EMPTY"});

        static final Map<String, Operator> operatorsMap;
        private String[] symbols;

        private Operator(String[] symbols) {
            this.symbols = symbols;
        }

        @JsonCreator
        public static Operator fromString(String symbol) {
            return operatorsMap.get(symbol);
        }

        @JsonValue
        public String getSymbol() {
            return this.symbols[0];
        }

        public String[] getSymbols() {
            return this.symbols;
        }

        public String toString() {
            return this.getSymbol();
        }

        static {
            operatorsMap = new HashMap<String, Operator>();
            for (Operator operator : Operator.values()) {
                for (String s : operator.symbols) {
                    operatorsMap.put(s, operator);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FilterCriteria {
        private String attributeName;
        private Operator operator;
        private String attributeValue;
        private Condition condition;
        private List<FilterCriteria> criterion;

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public void setOperator(Operator operator) {
            this.operator = operator;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public List<FilterCriteria> getCriterion() {
            return this.criterion;
        }

        public void setCriterion(List<FilterCriteria> criterion) {
            this.criterion = criterion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterCriteria that = (FilterCriteria)o;
            return Objects.equals(this.attributeName, that.attributeName) && Objects.equals((Object)this.operator, (Object)that.operator) && Objects.equals(this.attributeValue, that.attributeValue) && this.condition == that.condition && Objects.equals(this.criterion, that.criterion);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.attributeName, this.operator, this.attributeValue, this.condition, this.criterion});
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append('{');
            sb.append("attributeName='").append(this.attributeName).append('\'');
            sb.append(", operator=").append((Object)this.operator);
            sb.append(", attributeValue='").append(this.attributeValue).append('\'');
            sb.append(", condition=").append((Object)this.condition);
            sb.append(", criterion=").append(this.criterion);
            sb.append('}');
            return sb;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public static enum Condition {
            AND,
            OR;

        }
    }
}

