/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasClassificationDef {
    @Test
    public void testClassificationDefSerDeEmpty() {
        AtlasClassificationDef classificationDef = new AtlasClassificationDef("emptyClassificationDef");
        String jsonString = AtlasType.toJson((Object)classificationDef);
        AtlasClassificationDef classificationDef2 = (AtlasClassificationDef)AtlasType.fromJson((String)jsonString, AtlasClassificationDef.class);
        Assert.assertEquals((Object)classificationDef2, (Object)classificationDef, (String)"Incorrect serialization/deserialization of AtlasClassificationDef");
    }

    @Test
    public void testClassificationDefSerDe() {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDef();
        String jsonString = AtlasType.toJson((Object)classificationDef);
        AtlasClassificationDef classificationDef2 = (AtlasClassificationDef)AtlasType.fromJson((String)jsonString, AtlasClassificationDef.class);
        Assert.assertEquals((Object)classificationDef2, (Object)classificationDef, (String)"Incorrect serialization/deserialization of AtlasClassificationDef");
    }

    @Test
    public void testClassificationDefSerDeWithSuperType() {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDefWithSuperType();
        String jsonString = AtlasType.toJson((Object)classificationDef);
        AtlasClassificationDef classificationDef2 = (AtlasClassificationDef)AtlasType.fromJson((String)jsonString, AtlasClassificationDef.class);
        Assert.assertEquals((Object)classificationDef2, (Object)classificationDef, (String)"Incorrect serialization/deserialization of AtlasClassificationDef with superType");
    }

    @Test
    public void testClassificationDefSerDeWithSuperTypes() {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDefWithSuperTypes();
        String jsonString = AtlasType.toJson((Object)classificationDef);
        AtlasClassificationDef classificationDef2 = (AtlasClassificationDef)AtlasType.fromJson((String)jsonString, AtlasClassificationDef.class);
        Assert.assertEquals((Object)classificationDef2, (Object)classificationDef, (String)"Incorrect serialization/deserialization of AtlasClassificationDef with superTypes");
    }

    @Test
    public void testClassificationDefHasSuperTypeWithNoSuperType() {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDef();
        for (String superType : classificationDef.getSuperTypes()) {
            Assert.assertTrue((boolean)classificationDef.hasSuperType(superType));
        }
        Assert.assertFalse((boolean)classificationDef.hasSuperType("01234-xyzabc-;''-)("));
    }

    @Test
    public void testClassificationDefHasSuperTypeWithSuperType() {
        AtlasClassificationDef classificationDef = ModelTestUtil.getClassificationDefWithSuperTypes();
        for (String superType : classificationDef.getSuperTypes()) {
            Assert.assertTrue((boolean)classificationDef.hasSuperType(superType));
        }
        Assert.assertFalse((boolean)classificationDef.hasSuperType("01234-xyzabc-;''-)("));
    }
}

