/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasBigDecimalType {
    private final AtlasBuiltInTypes.AtlasBigDecimalType bigDecimalType = new AtlasBuiltInTypes.AtlasBigDecimalType();
    private final Object[] validValues = new Object[]{null, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1.0), "1.0"};
    private final Object[] negativeValues = new Object[]{(byte)-1, (short)-1, -1, -1L, Float.valueOf(-1.0f), -1.0, BigInteger.valueOf(-1L), BigDecimal.valueOf(-1.0), "-1.0"};
    private final Object[] invalidValues = new Object[]{"", "12ab", "abcd", "-12ab"};

    @Test
    public void testBigDecimalTypeDefaultValue() {
        BigDecimal defValue = this.bigDecimalType.createDefaultValue();
        Assert.assertEquals((Object)defValue, (Object)BigDecimal.valueOf(0L));
    }

    @Test
    public void testBigDecimalTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.bigDecimalType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.bigDecimalType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.bigDecimalType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testBigDecimalTypeGetNormalizedValue() {
        BigDecimal normalizedValue;
        Assert.assertNull((Object)this.bigDecimalType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            normalizedValue = this.bigDecimalType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            if (value instanceof BigInteger) {
                Assert.assertEquals((Object)normalizedValue, (Object)BigDecimal.valueOf(1L), (String)("value=" + value));
                continue;
            }
            Assert.assertEquals((Object)normalizedValue, (Object)BigDecimal.valueOf(1.0), (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            normalizedValue = this.bigDecimalType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            if (value instanceof BigInteger) {
                Assert.assertEquals((Object)normalizedValue, (Object)BigDecimal.valueOf(-1L), (String)("value=" + value));
                continue;
            }
            Assert.assertEquals((Object)normalizedValue, (Object)BigDecimal.valueOf(-1.0), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.bigDecimalType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testBigDecimalTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.bigDecimalType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.bigDecimalType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.bigDecimalType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

