/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasStringType {
    private final AtlasBuiltInTypes.AtlasStringType stringType = new AtlasBuiltInTypes.AtlasStringType();
    private final Object[] validValues = new Object[]{null, (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L), "1", "", "12ab", "abcd", "-12ab"};
    private final Object[] invalidValues = new Object[0];

    @Test
    public void testStringTypeDefaultValue() {
        String defValue = this.stringType.createDefaultValue();
        Assert.assertEquals((String)defValue, (String)"");
    }

    @Test
    public void testStringTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.stringType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.stringType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testStringTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.stringType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            String normalizedValue = this.stringType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((String)normalizedValue, (String)value.toString(), (String)("value=" + value));
        }
    }

    @Test
    public void testStringTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.stringType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.stringType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

