/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class MessageVersion
implements Comparable<MessageVersion>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final MessageVersion NO_VERSION = new MessageVersion("0");
    public static final MessageVersion VERSION_1;
    public static final MessageVersion CURRENT_VERSION;
    private String version;

    public MessageVersion() {
        this.version = MessageVersion.CURRENT_VERSION.version;
    }

    public MessageVersion(String version) {
        this.version = version;
        try {
            this.getVersionParts();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid version string : %s.", version), e);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public int compareTo(MessageVersion that) {
        if (that == null) {
            return 1;
        }
        Integer[] thisParts = this.getVersionParts();
        Integer[] thatParts = that.getVersionParts();
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int comp = this.getVersionPart(thisParts, i) - this.getVersionPart(thatParts, i);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((MessageVersion)that) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.getVersionParts());
    }

    public String toString() {
        return "MessageVersion[version=" + this.version + "]";
    }

    public Integer[] getVersionParts() {
        String[] sParts = this.version.split("\\.");
        ArrayList<Integer> iParts = new ArrayList<Integer>();
        int trailingZeros = 0;
        for (String sPart : sParts) {
            Integer iPart = new Integer(sPart);
            if (iPart == 0) {
                ++trailingZeros;
                continue;
            }
            for (int i = 0; i < trailingZeros; ++i) {
                iParts.add(0);
            }
            trailingZeros = 0;
            iParts.add(iPart);
        }
        return iParts.toArray(new Integer[iParts.size()]);
    }

    public Integer getVersionPart(Integer[] versionParts, int i) {
        return i < versionParts.length ? versionParts[i] : 0;
    }

    static {
        CURRENT_VERSION = VERSION_1 = new MessageVersion("1.0.0");
    }
}

