/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import com.google.common.annotations.VisibleForTesting;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.atlas.AtlasException;
import org.apache.atlas.model.notification.AtlasNotificationBaseMessage;
import org.apache.atlas.model.notification.AtlasNotificationMessage;
import org.apache.atlas.model.notification.AtlasNotificationStringMessage;
import org.apache.atlas.model.notification.MessageSource;
import org.apache.atlas.model.notification.MessageVersion;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNotification
implements NotificationInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNotification.class);
    private static String msgIdPrefix = UUID.randomUUID().toString();
    private static AtomicInteger msgIdSuffix = new AtomicInteger(0);
    public static final MessageVersion CURRENT_MESSAGE_VERSION = new MessageVersion("1.0.0");
    public static final int MAX_BYTES_PER_CHAR = 4;
    private static String localHostAddress = "";
    private static String currentUser = "";

    public AbstractNotification(Configuration applicationProperties) throws AtlasException {
    }

    @VisibleForTesting
    protected AbstractNotification() {
    }

    @Override
    public void init(String source, Object failedMessagesLogger) {
    }

    @Override
    public <T> void send(NotificationInterface.NotificationType type, List<T> messages) throws NotificationException {
        this.send(type, messages, new MessageSource());
    }

    @Override
    public <T> void send(NotificationInterface.NotificationType type, List<T> messages, MessageSource source) throws NotificationException {
        ArrayList<String> strMessages = new ArrayList<String>(messages.size());
        for (int index = 0; index < messages.size(); ++index) {
            AbstractNotification.createNotificationMessages(messages.get(index), strMessages, source);
        }
        this.sendInternal(type, strMessages);
    }

    @Override
    public <T> void send(NotificationInterface.NotificationType type, T ... messages) throws NotificationException {
        this.send(type, Arrays.asList(messages));
    }

    @Override
    public void setCurrentUser(String user) {
        currentUser = user;
    }

    public abstract void sendInternal(NotificationInterface.NotificationType var1, List<String> var2) throws NotificationException;

    public static String getMessageJson(Object message) {
        AtlasNotificationMessage notificationMsg = new AtlasNotificationMessage(CURRENT_MESSAGE_VERSION, message);
        return AtlasType.toV1Json((Object)notificationMsg);
    }

    private static String getHostAddress() {
        if (StringUtils.isEmpty((String)localHostAddress)) {
            try {
                localHostAddress = Inet4Address.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.warn("failed to get local host address", (Throwable)e);
                localHostAddress = "";
            }
        }
        return localHostAddress;
    }

    private static String getCurrentUser() {
        return currentUser;
    }

    public static void createNotificationMessages(Object message, List<String> msgJsonList, MessageSource source) {
        boolean msgLengthExceedsLimit;
        AtlasNotificationMessage notificationMsg = new AtlasNotificationMessage(CURRENT_MESSAGE_VERSION, message, AbstractNotification.getHostAddress(), AbstractNotification.getCurrentUser(), false, source);
        String msgJson = AtlasType.toV1Json((Object)notificationMsg);
        boolean bl = msgLengthExceedsLimit = msgJson.length() * 4 > AtlasNotificationBaseMessage.MESSAGE_MAX_LENGTH_BYTES;
        if (msgLengthExceedsLimit) {
            byte[] msgBytes = AtlasNotificationBaseMessage.getBytesUtf8((String)msgJson);
            boolean bl2 = msgLengthExceedsLimit = msgBytes.length > AtlasNotificationBaseMessage.MESSAGE_MAX_LENGTH_BYTES;
            if (msgLengthExceedsLimit) {
                byte[] encodedBytes;
                String msgId = AbstractNotification.getNextMessageId();
                AtlasNotificationBaseMessage.CompressionKind compressionKind = AtlasNotificationBaseMessage.CompressionKind.NONE;
                if (AtlasNotificationBaseMessage.MESSAGE_COMPRESSION_ENABLED) {
                    encodedBytes = AtlasNotificationBaseMessage.gzipCompressAndEncodeBase64((byte[])msgBytes);
                    compressionKind = AtlasNotificationBaseMessage.CompressionKind.GZIP;
                    LOG.info("Compressed large message: msgID={}, uncompressed={} bytes, compressed={} bytes", new Object[]{msgId, msgBytes.length, encodedBytes.length});
                    boolean bl3 = msgLengthExceedsLimit = encodedBytes.length > AtlasNotificationBaseMessage.MESSAGE_MAX_LENGTH_BYTES;
                    if (!msgLengthExceedsLimit) {
                        AtlasNotificationStringMessage compressedMsg = new AtlasNotificationStringMessage(encodedBytes, msgId, compressionKind);
                        msgJson = AtlasType.toV1Json((Object)compressedMsg);
                        msgBytes = null;
                    } else {
                        msgJson = null;
                        msgBytes = encodedBytes;
                    }
                }
                if (msgLengthExceedsLimit) {
                    encodedBytes = AtlasNotificationBaseMessage.MESSAGE_COMPRESSION_ENABLED ? msgBytes : AtlasNotificationBaseMessage.encodeBase64((byte[])msgBytes);
                    int splitCount = encodedBytes.length / AtlasNotificationBaseMessage.MESSAGE_MAX_LENGTH_BYTES;
                    if (encodedBytes.length % AtlasNotificationBaseMessage.MESSAGE_MAX_LENGTH_BYTES != 0) {
                        ++splitCount;
                    }
                    int offset = 0;
                    for (int i = 0; i < splitCount; ++i) {
                        int length = AtlasNotificationBaseMessage.MESSAGE_MAX_LENGTH_BYTES;
                        if (offset + length > encodedBytes.length) {
                            length = encodedBytes.length - offset;
                        }
                        AtlasNotificationStringMessage splitMsg = new AtlasNotificationStringMessage(encodedBytes, offset, length, msgId, compressionKind, i, splitCount);
                        String splitMsgJson = AtlasType.toV1Json((Object)splitMsg);
                        msgJsonList.add(splitMsgJson);
                        offset += length;
                    }
                    LOG.info("Split large message: msgID={}, splitCount={}, length={} bytes", new Object[]{msgId, splitCount, encodedBytes.length});
                }
            }
        }
        if (!msgLengthExceedsLimit) {
            msgJsonList.add(msgJson);
        }
    }

    private static String getNextMessageId() {
        String nextMsgIdPrefix = msgIdPrefix;
        int nextMsgIdSuffix = msgIdSuffix.getAndIncrement();
        if (nextMsgIdSuffix == Short.MAX_VALUE) {
            msgIdPrefix = UUID.randomUUID().toString();
            msgIdSuffix = new AtomicInteger(0);
        }
        return nextMsgIdPrefix + "_" + Integer.toString(nextMsgIdSuffix);
    }
}

