/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool.utils.local;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.atlas.notification.spool.SpoolUtils;
import org.apache.atlas.notification.spool.utils.local.FileOperation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOpRead
extends FileOperation {
    private static final Logger LOG = LoggerFactory.getLogger(FileOpRead.class);
    private String[] items;

    public FileOpRead(String source) {
        super(source);
    }

    @Override
    public FileLock run(RandomAccessFile randomAccessFile, FileChannel channel, String json) throws IOException {
        this.items = null;
        byte[] bytes = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(bytes);
        int rawRecords = 0;
        String allRecords = new String(bytes);
        if (StringUtils.isNotEmpty((String)allRecords)) {
            this.items = StringUtils.split((String)allRecords, (String)SpoolUtils.getLineSeparator());
            if (this.items != null) {
                rawRecords = this.items.length;
            }
        }
        LOG.info("FileOpRead.run(source={}): loaded file {}, raw records={}", new Object[]{this.getSource(), this.getFile().getAbsolutePath(), rawRecords});
        return null;
    }

    public String[] getItems() {
        return this.items;
    }
}

