/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.DeleteType;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext {
    private static final Logger METRICS = LoggerFactory.getLogger((String)"METRICS");
    private static final ThreadLocal<RequestContext> CURRENT_CONTEXT = new ThreadLocal();
    private static final Set<RequestContext> ACTIVE_REQUESTS = new HashSet<RequestContext>();
    private static final boolean isMetricsEnabled = METRICS.isDebugEnabled();
    private final long requestTime = System.currentTimeMillis();
    private final Map<String, AtlasEntityHeader> updatedEntities = new HashMap<String, AtlasEntityHeader>();
    private final Map<String, AtlasEntityHeader> deletedEntities = new HashMap<String, AtlasEntityHeader>();
    private final Map<String, AtlasEntity> entityCache = new HashMap<String, AtlasEntity>();
    private final Map<String, AtlasEntity.AtlasEntityWithExtInfo> entityExtInfoCache = new HashMap<String, AtlasEntity.AtlasEntityWithExtInfo>();
    private final Map<String, AtlasEntity> diffEntityCache = new HashMap<String, AtlasEntity>();
    private final Map<String, List<AtlasClassification>> addedPropagations = new HashMap<String, List<AtlasClassification>>();
    private final Map<String, List<AtlasClassification>> removedPropagations = new HashMap<String, List<AtlasClassification>>();
    private final AtlasPerfMetrics metrics = isMetricsEnabled ? new AtlasPerfMetrics() : null;
    private List<EntityGuidPair> entityGuidInRequest = null;
    private final Set<String> entitiesToSkipUpdate = new HashSet<String>();
    private final Set<String> onlyCAUpdateEntities = new HashSet<String>();
    private final Set<String> onlyBAUpdateEntities = new HashSet<String>();
    private final List<AtlasTask> queuedTasks = new ArrayList<AtlasTask>();
    private String user;
    private Set<String> userGroups;
    private String clientIPAddress;
    private List<String> forwardedAddresses;
    private DeleteType deleteType = DeleteType.DEFAULT;
    private boolean isPurgeRequested = false;
    private int maxAttempts = 1;
    private int attemptCount = 1;
    private boolean isImportInProgress = false;
    private boolean isInNotificationProcessing = false;
    private boolean isInTypePatching = false;
    private boolean createShellEntityForNonExistingReference = false;
    private boolean skipFailedEntities = false;
    private String currentTypePatchAction = "";

    private RequestContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestContext get() {
        RequestContext ret = CURRENT_CONTEXT.get();
        if (ret == null) {
            ret = new RequestContext();
            CURRENT_CONTEXT.set(ret);
            Set<RequestContext> set = ACTIVE_REQUESTS;
            synchronized (set) {
                ACTIVE_REQUESTS.add(ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        RequestContext instance = CURRENT_CONTEXT.get();
        if (instance != null) {
            instance.clearCache();
            Set<RequestContext> set = ACTIVE_REQUESTS;
            synchronized (set) {
                ACTIVE_REQUESTS.remove(instance);
            }
        }
        CURRENT_CONTEXT.remove();
    }

    public void clearCache() {
        this.updatedEntities.clear();
        this.deletedEntities.clear();
        this.entityCache.clear();
        this.entityExtInfoCache.clear();
        this.diffEntityCache.clear();
        this.addedPropagations.clear();
        this.removedPropagations.clear();
        this.entitiesToSkipUpdate.clear();
        this.onlyCAUpdateEntities.clear();
        this.onlyBAUpdateEntities.clear();
        this.queuedTasks.clear();
        if (this.metrics != null && !this.metrics.isEmpty()) {
            METRICS.debug(this.metrics.toString());
            this.metrics.clear();
        }
        if (this.entityGuidInRequest != null) {
            this.entityGuidInRequest.clear();
        }
    }

    public static String getCurrentUser() {
        String ret;
        RequestContext context = CURRENT_CONTEXT.get();
        String string = ret = context != null ? context.getUser() : null;
        if (StringUtils.isBlank((String)ret)) {
            try {
                ret = UserGroupInformation.getLoginUser().getShortUserName();
            }
            catch (Exception e) {
                ret = null;
            }
            if (StringUtils.isBlank((String)ret) && StringUtils.isBlank((String)(ret = System.getProperty("user.name")))) {
                ret = "atlas";
            }
        }
        return ret;
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUser(String user, Set<String> userGroups) {
        this.user = user;
        this.userGroups = userGroups;
    }

    public DeleteType getDeleteType() {
        return this.deleteType;
    }

    public void setDeleteType(DeleteType deleteType) {
        this.deleteType = deleteType == null ? DeleteType.DEFAULT : deleteType;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public boolean isImportInProgress() {
        return this.isImportInProgress;
    }

    public void setImportInProgress(boolean importInProgress) {
        this.isImportInProgress = importInProgress;
    }

    public boolean isPurgeRequested() {
        return this.isPurgeRequested;
    }

    public void setPurgeRequested(boolean isPurgeRequested) {
        this.isPurgeRequested = isPurgeRequested;
    }

    public boolean isInNotificationProcessing() {
        return this.isInNotificationProcessing;
    }

    public void setInNotificationProcessing(boolean inNotificationProcessing) {
        this.isInNotificationProcessing = inNotificationProcessing;
    }

    public boolean isInTypePatching() {
        return this.isInTypePatching;
    }

    public void setInTypePatching(boolean inTypePatching) {
        this.isInTypePatching = inTypePatching;
    }

    public boolean isCreateShellEntityForNonExistingReference() {
        return this.createShellEntityForNonExistingReference;
    }

    public void setCreateShellEntityForNonExistingReference(boolean createShellEntityForNonExistingReference) {
        this.createShellEntityForNonExistingReference = createShellEntityForNonExistingReference;
    }

    public boolean isSkipFailedEntities() {
        return this.skipFailedEntities;
    }

    public void setSkipFailedEntities(boolean skipFailedEntities) {
        this.skipFailedEntities = skipFailedEntities;
    }

    public String getCurrentTypePatchAction() {
        return this.currentTypePatchAction;
    }

    public void setCurrentTypePatchAction(String currentTypePatchAction) {
        this.currentTypePatchAction = currentTypePatchAction;
    }

    public void recordEntityUpdate(AtlasEntityHeader entity) {
        if (entity != null && entity.getGuid() != null && !this.entitiesToSkipUpdate.contains(entity.getGuid())) {
            this.updatedEntities.put(entity.getGuid(), entity);
        }
    }

    public void recordEntityToSkip(String guid) {
        if (!StringUtils.isEmpty((String)guid)) {
            this.entitiesToSkipUpdate.add(guid);
        }
    }

    public void recordEntityWithCustomAttributeUpdate(String guid) {
        if (!StringUtils.isEmpty((String)guid)) {
            this.onlyCAUpdateEntities.add(guid);
        }
    }

    public void recordEntityWithBusinessAttributeUpdate(String guid) {
        if (!StringUtils.isEmpty((String)guid)) {
            this.onlyBAUpdateEntities.add(guid);
        }
    }

    public boolean checkIfEntityIsForCustomAttributeUpdate(String guid) {
        return StringUtils.isNotEmpty((String)guid) && this.onlyCAUpdateEntities.contains(guid);
    }

    public boolean checkIfEntityIsForBusinessAttributeUpdate(String guid) {
        return StringUtils.isNotEmpty((String)guid) && this.onlyBAUpdateEntities.contains(guid);
    }

    public void recordEntityDelete(AtlasEntityHeader entity) {
        if (entity != null && entity.getGuid() != null) {
            this.deletedEntities.put(entity.getGuid(), entity);
        }
    }

    public void recordAddedPropagation(String guid, AtlasClassification classification) {
        if (StringUtils.isNotEmpty((String)guid) && classification != null) {
            List<AtlasClassification> classifications = this.addedPropagations.get(guid);
            if (classifications == null) {
                classifications = new ArrayList<AtlasClassification>();
            }
            classifications.add(classification);
            this.addedPropagations.put(guid, classifications);
        }
    }

    public static int getActiveRequestsCount() {
        return ACTIVE_REQUESTS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long earliestActiveRequestTime() {
        long ret = System.currentTimeMillis();
        Set<RequestContext> set = ACTIVE_REQUESTS;
        synchronized (set) {
            for (RequestContext context : ACTIVE_REQUESTS) {
                if (ret <= context.getRequestTime()) continue;
                ret = context.getRequestTime();
            }
        }
        return ret;
    }

    public void recordRemovedPropagation(String guid, AtlasClassification classification) {
        if (StringUtils.isNotEmpty((String)guid) && classification != null) {
            List<AtlasClassification> classifications = this.removedPropagations.get(guid);
            if (classifications == null) {
                classifications = new ArrayList<AtlasClassification>();
            }
            classifications.add(classification);
            this.removedPropagations.put(guid, classifications);
        }
    }

    public Map<String, List<AtlasClassification>> getAddedPropagations() {
        return this.addedPropagations;
    }

    public Map<String, List<AtlasClassification>> getRemovedPropagations() {
        return this.removedPropagations;
    }

    public void cache(AtlasEntity.AtlasEntityWithExtInfo entity) {
        if (entity != null && entity.getEntity() != null && entity.getEntity().getGuid() != null) {
            this.entityExtInfoCache.put(entity.getEntity().getGuid(), entity);
            this.entityCache.put(entity.getEntity().getGuid(), entity.getEntity());
        }
    }

    public void cache(AtlasEntity entity) {
        if (entity != null && entity.getGuid() != null) {
            this.entityCache.put(entity.getGuid(), entity);
        }
    }

    public void cacheDifferentialEntity(AtlasEntity entity) {
        if (entity != null && entity.getGuid() != null) {
            this.diffEntityCache.put(entity.getGuid(), entity);
        }
    }

    public AtlasEntity getDifferentialEntity(String guid) {
        return this.diffEntityCache.get(guid);
    }

    public Collection<AtlasEntity> getDifferentialEntities() {
        return this.diffEntityCache.values();
    }

    public Collection<AtlasEntityHeader> getUpdatedEntities() {
        return this.updatedEntities.values();
    }

    public Collection<AtlasEntityHeader> getDeletedEntities() {
        return this.deletedEntities.values();
    }

    public void clearRemovePropagations() {
        this.removedPropagations.clear();
    }

    public void clearAddedPropagations() {
        this.addedPropagations.clear();
    }

    public AtlasEntity.AtlasEntityWithExtInfo getEntityWithExtInfo(String guid) {
        return this.entityExtInfoCache.get(guid);
    }

    public AtlasEntity getEntity(String guid) {
        return this.entityCache.get(guid);
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public boolean isUpdatedEntity(String guid) {
        return this.updatedEntities.containsKey(guid);
    }

    public boolean isDeletedEntity(String guid) {
        return this.deletedEntities.containsKey(guid);
    }

    public AtlasPerfMetrics.MetricRecorder startMetricRecord(String name) {
        return this.metrics != null ? this.metrics.getMetricRecorder(name) : null;
    }

    public void endMetricRecord(AtlasPerfMetrics.MetricRecorder recorder) {
        if (this.metrics != null && recorder != null) {
            this.metrics.recordMetric(recorder);
        }
    }

    public void recordEntityGuidUpdate(AtlasEntity entity, String guidInRequest) {
        this.recordEntityGuidUpdate(new EntityGuidPair(entity, guidInRequest));
    }

    public void recordEntityGuidUpdate(AtlasObjectId entity, String guidInRequest) {
        this.recordEntityGuidUpdate(new EntityGuidPair(entity, guidInRequest));
    }

    public void recordEntityGuidUpdate(Map entity, String guidInRequest) {
        this.recordEntityGuidUpdate(new EntityGuidPair(entity, guidInRequest));
    }

    public void recordEntityGuidUpdate(EntityGuidPair record) {
        if (this.entityGuidInRequest == null) {
            this.entityGuidInRequest = new ArrayList<EntityGuidPair>();
        }
        this.entityGuidInRequest.add(record);
    }

    public void resetEntityGuidUpdates() {
        if (this.entityGuidInRequest != null) {
            for (EntityGuidPair entityGuidPair : this.entityGuidInRequest) {
                entityGuidPair.resetEntityGuid();
            }
        }
    }

    public void queueTask(AtlasTask task) {
        this.queuedTasks.add(task);
    }

    public List<AtlasTask> getQueuedTasks() {
        return this.queuedTasks;
    }

    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    public void setForwardedAddresses(List<String> forwardedAddresses) {
        this.forwardedAddresses = forwardedAddresses;
    }

    public class EntityGuidPair {
        private final Object entity;
        private final String guid;

        public EntityGuidPair(AtlasEntity entity, String guid) {
            this.entity = entity;
            this.guid = guid;
        }

        public EntityGuidPair(AtlasObjectId entity, String guid) {
            this.entity = entity;
            this.guid = guid;
        }

        public EntityGuidPair(Map entity, String guid) {
            this.entity = entity;
            this.guid = guid;
        }

        public void resetEntityGuid() {
            if (this.entity instanceof AtlasEntity) {
                ((AtlasEntity)this.entity).setGuid(this.guid);
            } else if (this.entity instanceof AtlasObjectId) {
                ((AtlasObjectId)this.entity).setGuid(this.guid);
            } else if (this.entity instanceof Map) {
                ((Map)this.entity).put("guid", this.guid);
            }
        }
    }
}

