/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import org.apache.avro.Schema;
import org.apache.avro.idl.SchemaResolver;
import org.apache.avro.idl.SchemaVisitor;
import org.apache.avro.idl.SchemaVisitorAction;

public final class IsResolvedSchemaVisitor
implements SchemaVisitor<Boolean> {
    boolean hasUnresolvedParts = false;

    IsResolvedSchemaVisitor() {
    }

    @Override
    public SchemaVisitorAction visitTerminal(Schema terminal) {
        this.hasUnresolvedParts = SchemaResolver.isUnresolvedSchema(terminal);
        return this.hasUnresolvedParts ? SchemaVisitorAction.TERMINATE : SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction visitNonTerminal(Schema nonTerminal) {
        this.hasUnresolvedParts = SchemaResolver.isUnresolvedSchema(nonTerminal);
        if (this.hasUnresolvedParts) {
            return SchemaVisitorAction.TERMINATE;
        }
        if (nonTerminal.getType() == Schema.Type.RECORD && !nonTerminal.hasFields()) {
            return SchemaVisitorAction.SKIP_SUBTREE;
        }
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction afterVisitNonTerminal(Schema nonTerminal) {
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public Boolean get() {
        return !this.hasUnresolvedParts;
    }
}

