/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.idl;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.idl.SchemaVisitor;
import org.apache.avro.idl.SchemaVisitorAction;

public final class Schemas {
    private Schemas() {
    }

    public static <T> T visit(Schema start, SchemaVisitor<T> visitor) {
        Object current;
        IdentityHashMap<Schema, Schema> visited = new IdentityHashMap<Schema, Schema>();
        ArrayDeque<Object> dq = new ArrayDeque<Object>();
        dq.push(start);
        block11: while ((current = dq.poll()) != null) {
            boolean terminate;
            if (current instanceof Supplier) {
                SchemaVisitorAction action = (SchemaVisitorAction)((Object)((Supplier)current).get());
                switch (action) {
                    case CONTINUE: {
                        continue block11;
                    }
                    case SKIP_SIBLINGS: {
                        while (dq.peek() instanceof Schema) {
                            dq.remove();
                        }
                        continue block11;
                    }
                    case TERMINATE: {
                        return visitor.get();
                    }
                }
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action));
            }
            Schema schema = (Schema)current;
            if (visited.containsKey(schema)) {
                terminate = Schemas.visitTerminal(visitor, schema, dq);
            } else {
                Schema.Type type = schema.getType();
                switch (type) {
                    case ARRAY: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singleton(schema.getElementType()));
                        visited.put(schema, schema);
                        break;
                    }
                    case RECORD: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, () -> schema.getFields().stream().map(Schema.Field::schema).collect(Collectors.toCollection(ArrayDeque::new)).descendingIterator());
                        visited.put(schema, schema);
                        break;
                    }
                    case UNION: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, schema.getTypes());
                        visited.put(schema, schema);
                        break;
                    }
                    case MAP: {
                        terminate = Schemas.visitNonTerminal(visitor, schema, dq, Collections.singleton(schema.getValueType()));
                        visited.put(schema, schema);
                        break;
                    }
                    default: {
                        terminate = Schemas.visitTerminal(visitor, schema, dq);
                    }
                }
            }
            if (!terminate) continue;
            return visitor.get();
        }
        return visitor.get();
    }

    private static boolean visitNonTerminal(SchemaVisitor<?> visitor, Schema schema, Deque<Object> dq, Iterable<Schema> itSupp) {
        SchemaVisitorAction action = visitor.visitNonTerminal(schema);
        switch (action) {
            case CONTINUE: {
                dq.push(() -> visitor.afterVisitNonTerminal(schema));
                itSupp.forEach(dq::push);
                break;
            }
            case SKIP_SUBTREE: {
                dq.push(() -> visitor.afterVisitNonTerminal(schema));
                break;
            }
            case SKIP_SIBLINGS: {
                while (dq.peek() instanceof Schema) {
                    dq.remove();
                }
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }

    private static boolean visitTerminal(SchemaVisitor<?> visitor, Schema schema, Deque<Object> dq) {
        SchemaVisitorAction action = visitor.visitTerminal(schema);
        switch (action) {
            case CONTINUE: {
                break;
            }
            case SKIP_SIBLINGS: {
                while (dq.peek() instanceof Schema) {
                    dq.remove();
                }
                break;
            }
            case TERMINATE: {
                return true;
            }
            default: {
                throw new UnsupportedOperationException("Invalid action " + (Object)((Object)action) + " for " + schema);
            }
        }
        return false;
    }
}

