/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DataFileInteropTest {
    private static final File DATAFILE_DIR = new File(System.getProperty("test.dir", "/tmp"));

    @BeforeClass
    public static void printDir() {
        System.out.println("Reading data files from directory: " + DATAFILE_DIR.getAbsolutePath());
    }

    @Test
    public void testGeneratedGeneric() throws IOException {
        System.out.println("Reading with generic:");
        DatumReaderProvider provider = GenericDatumReader::new;
        this.readFiles(provider);
    }

    @Test
    public void testGeneratedSpecific() throws IOException {
        System.out.println("Reading with specific:");
        DatumReaderProvider provider = SpecificDatumReader::new;
        this.readFiles(provider);
    }

    private <T> void readFiles(DatumReaderProvider<T> provider) throws IOException {
        for (File f : Objects.requireNonNull(DATAFILE_DIR.listFiles())) {
            System.out.println("Reading: " + f.getName());
            try (DataFileReader reader = (DataFileReader)DataFileReader.openReader((File)f, provider.get());){
                byte[] user_metadata = reader.getMeta("user_metadata");
                if (user_metadata != null) {
                    Assert.assertArrayEquals((byte[])"someByteArray".getBytes(StandardCharsets.UTF_8), (byte[])user_metadata);
                }
                int i = 0;
                for (Object datum : reader) {
                    ++i;
                    Assert.assertNotNull(datum);
                }
                Assert.assertNotEquals((long)0L, (long)i);
            }
        }
    }

    static interface DatumReaderProvider<T> {
        public DatumReader<T> get();
    }
}

