/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.util.Utf8;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProtocolGeneric {
    private static final Logger LOG = LoggerFactory.getLogger(TestProtocolGeneric.class);
    protected static final File FILE = new File("../../../share/test/schemas/simple.avpr");
    protected static final Protocol PROTOCOL;
    private static boolean throwUndeclaredError;
    protected static SocketServer server;
    protected static Transceiver client;
    protected static GenericRequestor requestor;

    @Before
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new SocketServer((Responder)new TestResponder(), (SocketAddress)new InetSocketAddress(0));
        server.start();
        client = new SocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()));
        requestor = new GenericRequestor(PROTOCOL, client);
    }

    @Test
    public void testHello() throws Exception {
        GenericData.Record params = new GenericData.Record(((Protocol.Message)PROTOCOL.getMessages().get("hello")).getRequest());
        params.put("greeting", (Object)new Utf8("bob"));
        Utf8 response = (Utf8)requestor.request("hello", (Object)params);
        Assert.assertEquals((Object)new Utf8("goodbye"), (Object)response);
    }

    @Test
    public void testEcho() throws Exception {
        GenericData.Record record = new GenericData.Record(PROTOCOL.getType("TestRecord"));
        record.put("name", (Object)new Utf8("foo"));
        record.put("kind", (Object)new GenericData.EnumSymbol(PROTOCOL.getType("Kind"), "BAR"));
        record.put("hash", (Object)new GenericData.Fixed(PROTOCOL.getType("MD5"), new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        GenericData.Record params = new GenericData.Record(((Protocol.Message)PROTOCOL.getMessages().get("echo")).getRequest());
        params.put("record", (Object)record);
        Object echoed = requestor.request("echo", (Object)params);
        Assert.assertEquals((Object)record, (Object)echoed);
    }

    @Test
    public void testEchoBytes() throws Exception {
        Random random = new Random();
        int length = random.nextInt(16384);
        GenericData.Record params = new GenericData.Record(((Protocol.Message)PROTOCOL.getMessages().get("echoBytes")).getRequest());
        ByteBuffer data = ByteBuffer.allocate(length);
        random.nextBytes(data.array());
        data.flip();
        params.put("data", (Object)data);
        Object echoed = requestor.request("echoBytes", (Object)params);
        Assert.assertEquals((Object)data, (Object)echoed);
    }

    @Test
    public void testError() throws Exception {
        GenericData.Record params = new GenericData.Record(((Protocol.Message)PROTOCOL.getMessages().get("error")).getRequest());
        AvroRemoteException error = null;
        try {
            requestor.request("error", (Object)params);
        }
        catch (AvroRemoteException e) {
            error = e;
        }
        Assert.assertNotNull((Object)((Object)error));
        Assert.assertEquals((Object)"an error", (Object)((GenericRecord)error.getValue()).get("message").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUndeclaredError() throws Exception {
        throwUndeclaredError = true;
        RuntimeException error = null;
        GenericData.Record params = new GenericData.Record(((Protocol.Message)PROTOCOL.getMessages().get("error")).getRequest());
        try {
            requestor.request("error", (Object)params);
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            throwUndeclaredError = false;
        }
        Assert.assertNotNull((Object)error);
        Assert.assertTrue((boolean)error.toString().contains("foo"));
    }

    @Test
    public void testHandshake() throws Exception {
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("extra", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, null));
        fields.add(new Schema.Field("greeting", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        Protocol.Message message = protocol.createMessage("hello", null, new LinkedHashMap(), Schema.createRecord(fields), Schema.create((Schema.Type)Schema.Type.STRING), Schema.createUnion(new ArrayList()));
        protocol.getMessages().put("hello", message);
        try (SocketTransceiver t = new SocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()));){
            GenericRequestor r = new GenericRequestor(protocol, (Transceiver)t);
            GenericData.Record params = new GenericData.Record(message.getRequest());
            params.put("extra", (Object)Boolean.TRUE);
            params.put("greeting", (Object)new Utf8("bob"));
            Utf8 response = (Utf8)r.request("hello", (Object)params);
            Assert.assertEquals((Object)new Utf8("goodbye"), (Object)response);
        }
    }

    @Test
    public void testResponseChange() throws Exception {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Schema.Field f : PROTOCOL.getType("TestRecord").getFields()) {
            fields.add(new Schema.Field(f.name(), f.schema(), null, null));
        }
        fields.add(new Schema.Field("extra", Schema.create((Schema.Type)Schema.Type.BOOLEAN), null, (Object)true));
        Schema record = Schema.createRecord((String)"TestRecord", null, (String)"org.apache.avro.test", (boolean)false);
        record.setFields(fields);
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        ArrayList<Schema.Field> params = new ArrayList<Schema.Field>();
        params.add(new Schema.Field("record", record, null, null));
        Protocol.Message message = protocol.createMessage("echo", null, new LinkedHashMap(), Schema.createRecord(params), record, Schema.createUnion(new ArrayList()));
        protocol.getMessages().put("echo", message);
        try (SocketTransceiver t = new SocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()));){
            GenericRequestor r = new GenericRequestor(protocol, (Transceiver)t);
            GenericData.Record args = new GenericData.Record(message.getRequest());
            GenericData.Record rec = new GenericData.Record(record);
            rec.put("name", (Object)new Utf8("foo"));
            rec.put("kind", (Object)new GenericData.EnumSymbol(PROTOCOL.getType("Kind"), "BAR"));
            rec.put("hash", (Object)new GenericData.Fixed(PROTOCOL.getType("MD5"), new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
            rec.put("extra", (Object)Boolean.TRUE);
            args.put("record", (Object)rec);
            GenericRecord response = (GenericRecord)r.request("echo", (Object)args);
            Assert.assertEquals((Object)rec, (Object)response);
        }
    }

    @AfterClass
    public static void testStopServer() throws Exception {
        client.close();
        server.close();
    }

    static {
        try {
            PROTOCOL = Protocol.parse((File)FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class TestResponder
    extends GenericResponder {
        public TestResponder() {
            super(PROTOCOL);
        }

        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            GenericRecord params = (GenericRecord)request;
            if ("hello".equals(message.getName())) {
                LOG.info("hello: " + params.get("greeting"));
                return new Utf8("goodbye");
            }
            if ("echo".equals(message.getName())) {
                Object record = params.get("record");
                LOG.info("echo: " + record);
                return record;
            }
            if ("echoBytes".equals(message.getName())) {
                Object data = params.get("data");
                LOG.info("echoBytes: " + data);
                return data;
            }
            if ("error".equals(message.getName())) {
                if (throwUndeclaredError) {
                    throw new RuntimeException("foo");
                }
                GenericData.Record error = new GenericData.Record(PROTOCOL.getType("TestError"));
                error.put("message", (Object)new Utf8("an error"));
                throw new AvroRemoteException((Object)error);
            }
            throw new AvroRuntimeException("unexpected message: " + message.getName());
        }
    }
}

