/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.util.ArrayList;
import java.util.Optional;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.test.http.HttpMethod;
import org.apache.avro.test.http.HttpRequest;
import org.apache.avro.test.http.HttpURI;
import org.apache.avro.test.http.NetworkType;
import org.apache.avro.test.http.QueryParameter;
import org.apache.avro.test.http.Request;
import org.apache.avro.test.http.UserAgent;
import org.apache.avro.test.nullable.RecordWithNullables;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificBuilderTree {
    private Request.Builder createPartialBuilder() {
        Request.Builder requestBuilder = Request.newBuilder();
        requestBuilder.setTimestamp(1234567890L);
        requestBuilder.getConnectionBuilder().setNetworkType(NetworkType.IPv4);
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123").setId("Foo");
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        if (!requestBuilder.getHttpRequestBuilder().getURIBuilder().hasParameters()) {
            requestBuilder.getHttpRequestBuilder().getURIBuilder().setParameters(new ArrayList<QueryParameter>());
        }
        requestBuilder.getHttpRequestBuilder().getURIBuilder().getParameters().add(QueryParameter.newBuilder().setName("Foo").setValue("Bar").build());
        return requestBuilder;
    }

    @Test(expected=AvroMissingFieldException.class)
    public void failOnIncompleteTree() {
        try {
            this.createPartialBuilder().build();
        }
        catch (AvroMissingFieldException amfe) {
            Assert.assertEquals((Object)"Field networkAddress type:STRING pos:1 not set and has no default value", (Object)amfe.getMessage());
            Assert.assertEquals((Object)"Path in schema: --> connection --> networkAddress", (Object)amfe.toString());
            throw amfe;
        }
        Assert.fail((String)"Should NEVER get here");
    }

    @Test
    public void copyBuilder() {
        Request.Builder requestBuilder1 = this.createPartialBuilder();
        Request.Builder requestBuilder2 = Request.newBuilder(requestBuilder1);
        requestBuilder1.getConnectionBuilder().setNetworkAddress("1.1.1.1");
        requestBuilder2.getConnectionBuilder().setNetworkAddress("2.2.2.2");
        requestBuilder2.getHttpRequestBuilder().getUserAgentBuilder().setId("Bar");
        Request request1 = requestBuilder1.build();
        Request request2 = requestBuilder2.build();
        Assert.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request1.getConnection().getNetworkType()));
        Assert.assertEquals((Object)"1.1.1.1", (Object)request1.getConnection().getNetworkAddress());
        Assert.assertEquals((Object)"Chrome 123", (Object)request1.getHttpRequest().getUserAgent().getUseragent());
        Assert.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getUserAgent().getId());
        Assert.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request1.getHttpRequest().getURI().getMethod()));
        Assert.assertEquals((Object)"/index.html", (Object)request1.getHttpRequest().getURI().getPath());
        Assert.assertEquals((long)1L, (long)request1.getHttpRequest().getURI().getParameters().size());
        Assert.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getName());
        Assert.assertEquals((Object)"Bar", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getValue());
        Assert.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request2.getConnection().getNetworkType()));
        Assert.assertEquals((Object)"2.2.2.2", (Object)request2.getConnection().getNetworkAddress());
        Assert.assertEquals((Object)"Chrome 123", (Object)request2.getHttpRequest().getUserAgent().getUseragent());
        Assert.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getUserAgent().getId());
        Assert.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request2.getHttpRequest().getURI().getMethod()));
        Assert.assertEquals((Object)"/index.html", (Object)request2.getHttpRequest().getURI().getPath());
        Assert.assertEquals((long)1L, (long)request2.getHttpRequest().getURI().getParameters().size());
        Assert.assertEquals((Object)"Foo", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getName());
        Assert.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getValue());
    }

    @Test
    public void createBuilderFromInstance() {
        Request.Builder requestBuilder1 = this.createPartialBuilder();
        requestBuilder1.getConnectionBuilder().setNetworkAddress("1.1.1.1");
        Request request1 = requestBuilder1.build();
        Request.Builder requestBuilder2 = Request.newBuilder(request1);
        requestBuilder2.getConnectionBuilder().setNetworkAddress("2.2.2.2");
        requestBuilder2.getHttpRequestBuilder().getUserAgentBuilder().setId("Bar");
        requestBuilder2.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.POST);
        requestBuilder2.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Firefox 456");
        Request request2 = requestBuilder2.build();
        Assert.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request1.getConnection().getNetworkType()));
        Assert.assertEquals((Object)"1.1.1.1", (Object)request1.getConnection().getNetworkAddress());
        Assert.assertEquals((Object)"Chrome 123", (Object)request1.getHttpRequest().getUserAgent().getUseragent());
        Assert.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getUserAgent().getId());
        Assert.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request1.getHttpRequest().getURI().getMethod()));
        Assert.assertEquals((Object)"/index.html", (Object)request1.getHttpRequest().getURI().getPath());
        Assert.assertEquals((long)1L, (long)request1.getHttpRequest().getURI().getParameters().size());
        Assert.assertEquals((Object)"Foo", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getName());
        Assert.assertEquals((Object)"Bar", (Object)request1.getHttpRequest().getURI().getParameters().get(0).getValue());
        Assert.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request2.getConnection().getNetworkType()));
        Assert.assertEquals((Object)"2.2.2.2", (Object)request2.getConnection().getNetworkAddress());
        Assert.assertEquals((Object)"Firefox 456", (Object)request2.getHttpRequest().getUserAgent().getUseragent());
        Assert.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getUserAgent().getId());
        Assert.assertEquals((Object)((Object)HttpMethod.POST), (Object)((Object)request2.getHttpRequest().getURI().getMethod()));
        Assert.assertEquals((Object)"/index.html", (Object)request2.getHttpRequest().getURI().getPath());
        Assert.assertEquals((long)1L, (long)request2.getHttpRequest().getURI().getParameters().size());
        Assert.assertEquals((Object)"Foo", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getName());
        Assert.assertEquals((Object)"Bar", (Object)request2.getHttpRequest().getURI().getParameters().get(0).getValue());
    }

    private Request.Builder createLastOneTestsBuilder() {
        Request.Builder requestBuilder = Request.newBuilder();
        requestBuilder.setTimestamp(1234567890L);
        requestBuilder.getConnectionBuilder().setNetworkType(NetworkType.IPv4).setNetworkAddress("1.1.1.1");
        return requestBuilder;
    }

    @Test
    public void lastOneWins_Setter() {
        Request.Builder requestBuilder = this.createLastOneTestsBuilder();
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123").setId("Foo");
        HttpRequest httpRequest = HttpRequest.newBuilder().setUserAgent(new UserAgent("Bar", "Firefox 321")).setURI(HttpURI.newBuilder().setMethod(HttpMethod.POST).setPath("/login.php").build()).build();
        Request request = requestBuilder.setHttpRequest(httpRequest).build();
        Assert.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request.getConnection().getNetworkType()));
        Assert.assertEquals((Object)"1.1.1.1", (Object)request.getConnection().getNetworkAddress());
        Assert.assertEquals((long)0L, (long)request.getHttpRequest().getURI().getParameters().size());
        Assert.assertEquals((Object)"Firefox 321", (Object)request.getHttpRequest().getUserAgent().getUseragent());
        Assert.assertEquals((Object)"Bar", (Object)request.getHttpRequest().getUserAgent().getId());
        Assert.assertEquals((Object)((Object)HttpMethod.POST), (Object)((Object)request.getHttpRequest().getURI().getMethod()));
        Assert.assertEquals((Object)"/login.php", (Object)request.getHttpRequest().getURI().getPath());
    }

    @Test
    public void lastOneWins_Builder() {
        Request.Builder requestBuilder = this.createLastOneTestsBuilder();
        HttpRequest httpRequest = HttpRequest.newBuilder().setUserAgent(new UserAgent("Bar", "Firefox 321")).setURI(HttpURI.newBuilder().setMethod(HttpMethod.POST).setPath("/login.php").build()).build();
        requestBuilder.setHttpRequest(httpRequest);
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123").setId("Foo");
        Request request = requestBuilder.build();
        Assert.assertEquals((Object)((Object)NetworkType.IPv4), (Object)((Object)request.getConnection().getNetworkType()));
        Assert.assertEquals((Object)"1.1.1.1", (Object)request.getConnection().getNetworkAddress());
        Assert.assertEquals((Object)"Chrome 123", (Object)request.getHttpRequest().getUserAgent().getUseragent());
        Assert.assertEquals((Object)"Foo", (Object)request.getHttpRequest().getUserAgent().getId());
        Assert.assertEquals((long)0L, (long)request.getHttpRequest().getURI().getParameters().size());
        Assert.assertEquals((Object)((Object)HttpMethod.GET), (Object)((Object)request.getHttpRequest().getURI().getMethod()));
        Assert.assertEquals((Object)"/index.html", (Object)request.getHttpRequest().getURI().getPath());
    }

    @Test
    public void copyBuilderWithNullables() {
        RecordWithNullables.Builder builder2 = RecordWithNullables.newBuilder();
        Assert.assertFalse((boolean)builder2.hasNullableRecordBuilder());
        Assert.assertFalse((boolean)builder2.hasNullableRecord());
        Assert.assertFalse((boolean)builder2.hasNullableString());
        Assert.assertFalse((boolean)builder2.hasNullableLong());
        Assert.assertFalse((boolean)builder2.hasNullableInt());
        Assert.assertFalse((boolean)builder2.hasNullableMap());
        Assert.assertFalse((boolean)builder2.hasNullableArray());
        RecordWithNullables.Builder builderCopy = RecordWithNullables.newBuilder(builder2);
        Assert.assertFalse((boolean)builderCopy.hasNullableRecordBuilder());
        Assert.assertFalse((boolean)builderCopy.hasNullableRecord());
        Assert.assertFalse((boolean)builderCopy.hasNullableString());
        Assert.assertFalse((boolean)builderCopy.hasNullableLong());
        Assert.assertFalse((boolean)builderCopy.hasNullableInt());
        Assert.assertFalse((boolean)builderCopy.hasNullableMap());
        Assert.assertFalse((boolean)builderCopy.hasNullableArray());
        builderCopy.getNullableRecordBuilder();
    }

    @Test
    public void copyBuilderWithNullablesAndSetToNull() {
        RecordWithNullables.Builder builder2 = RecordWithNullables.newBuilder();
        Assert.assertFalse((boolean)builder2.hasNullableRecordBuilder());
        Assert.assertFalse((boolean)builder2.hasNullableRecord());
        Assert.assertFalse((boolean)builder2.hasNullableString());
        Assert.assertFalse((boolean)builder2.hasNullableLong());
        Assert.assertFalse((boolean)builder2.hasNullableInt());
        Assert.assertFalse((boolean)builder2.hasNullableMap());
        Assert.assertFalse((boolean)builder2.hasNullableArray());
        builder2.setNullableRecordBuilder(null);
        builder2.setNullableRecord(null);
        builder2.setNullableString(null);
        builder2.setNullableLong(null);
        builder2.setNullableInt(null);
        builder2.setNullableMap(null);
        builder2.setNullableArray(null);
        Assert.assertFalse((boolean)builder2.hasNullableRecordBuilder());
        Assert.assertTrue((boolean)builder2.hasNullableRecord());
        Assert.assertTrue((boolean)builder2.hasNullableString());
        Assert.assertTrue((boolean)builder2.hasNullableLong());
        Assert.assertTrue((boolean)builder2.hasNullableInt());
        Assert.assertTrue((boolean)builder2.hasNullableMap());
        Assert.assertTrue((boolean)builder2.hasNullableArray());
        builder2.getNullableRecordBuilder();
        Assert.assertTrue((boolean)builder2.hasNullableRecordBuilder());
        Assert.assertFalse((boolean)builder2.hasNullableRecord());
        RecordWithNullables.Builder builderCopy = RecordWithNullables.newBuilder(builder2);
        Assert.assertTrue((boolean)builder2.hasNullableRecordBuilder());
        Assert.assertFalse((boolean)builder2.hasNullableRecord());
        Assert.assertTrue((boolean)builder2.hasNullableString());
        Assert.assertTrue((boolean)builder2.hasNullableLong());
        Assert.assertTrue((boolean)builder2.hasNullableInt());
        Assert.assertTrue((boolean)builder2.hasNullableMap());
        Assert.assertTrue((boolean)builder2.hasNullableArray());
    }

    @Test
    public void getBuilderForRecordWithNullRecord() {
        RecordWithNullables recordWithNullables = RecordWithNullables.newBuilder().build();
        RecordWithNullables.Builder builder2 = RecordWithNullables.newBuilder(recordWithNullables);
        builder2.getNullableRecordBuilder();
    }

    @Test
    public void getBuilderForNullRecord() {
        RecordWithNullables.newBuilder((RecordWithNullables)null);
    }

    @Test
    public void getBuilderForNullBuilder() {
        RecordWithNullables.newBuilder((RecordWithNullables.Builder)null);
    }

    @Test
    public void validateBrowsingOptionals() {
        Request.Builder requestBuilder = Request.newBuilder();
        requestBuilder.setTimestamp(1234567890L);
        requestBuilder.getHttpRequestBuilder().getUserAgentBuilder().setUseragent("Chrome 123");
        requestBuilder.getHttpRequestBuilder().getURIBuilder().setMethod(HttpMethod.GET).setPath("/index.html");
        Request request = requestBuilder.build();
        Assert.assertEquals((Object)"Chrome 123", (Object)Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalUserAgent).flatMap(UserAgent::getOptionalUseragent).orElse("UNKNOWN"));
        Assert.assertFalse((boolean)Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalUserAgent).flatMap(UserAgent::getOptionalId).isPresent());
        Assert.assertEquals((Object)((Object)HttpMethod.GET), Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalURI).flatMap(HttpURI::getOptionalMethod).orElse(null));
        Assert.assertEquals((Object)"/index.html", Optional.of(request).flatMap(Request::getOptionalHttpRequest).flatMap(HttpRequest::getOptionalURI).flatMap(HttpURI::getOptionalPath).orElse(null));
    }
}

